; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; RUN: llc -mtriple=aarch64-gnu-linux < %s | FileCheck -check-prefixes=CHECK %s
; RUN: llc -mtriple=aarch64-windows-pc-msvc < %s | FileCheck -check-prefixes=WINDOWS %s

define { half, i32 } @test_frexp_f16_i32(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f16_i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, h0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    fcvt h0, d0
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  ret { half, i32 } %result
}

define half @test_frexp_f16_i32_only_use_fract(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f16_i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, h0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt h0, d0
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 0
  ret half %result.0
}

define i32 @test_frexp_f16_i32_only_use_exp(half %a) nounwind {
; CHECK-LABEL: test_frexp_f16_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f16_i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, h0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { half, i32 } @llvm.frexp.f16.i32(half %a)
  %result.0 = extractvalue { half, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x half>, <2 x i32> } @test_frexp_v2f16_v2i32(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #36
; CHECK-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    add x19, sp, #36
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    add x0, sp, #32
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    mov h1, v1.h[2]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    mov h1, v1.h[3]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    ldr s1, [sp, #32]
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    mov v0.h[3], v2.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f16_v2i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #64
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    mov h1, v0.h[1]
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #36
; WINDOWS-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x19, sp, #36
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h0, d0
; WINDOWS-NEXT:    add x0, sp, #32
; WINDOWS-NEXT:    fcvt d1, h1
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fmov d0, d1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h2, d0
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    mov h1, v1.h[2]
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov v2.h[1], v1.h[0]
; WINDOWS-NEXT:    str q2, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h2, d0
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    mov h1, v1.h[3]
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov v1.h[2], v2.h[0]
; WINDOWS-NEXT:    str q1, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt h2, d0
; WINDOWS-NEXT:    ldr s1, [sp, #32]
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d1 killed $d1 killed $q1
; WINDOWS-NEXT:    mov v0.h[3], v2.h[0]
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #64
; WINDOWS-NEXT:    ret
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  ret { <2 x half>, <2 x i32> } %result
}

define <2 x half> @test_frexp_v2f16_v2i32_only_use_fract(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    mov h1, v0.h[1]
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h0, s0
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    fcvt s1, h1
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    fmov s0, s1
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #56
; CHECK-NEXT:    mov h1, v1.h[2]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov v2.h[1], v1.h[0]
; CHECK-NEXT:    str q2, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    fcvt h2, s0
; CHECK-NEXT:    add x0, sp, #60
; CHECK-NEXT:    mov h1, v1.h[3]
; CHECK-NEXT:    fcvt s0, h1
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    mov v1.h[2], v2.h[0]
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    fcvt h1, s0
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-NEXT:    mov v0.h[3], v1.h[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f16_v2i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #64
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    mov h1, v0.h[1]
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h0, d0
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    fcvt d1, h1
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fmov d0, d1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h2, d0
; WINDOWS-NEXT:    add x0, sp, #56
; WINDOWS-NEXT:    mov h1, v1.h[2]
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov v2.h[1], v1.h[0]
; WINDOWS-NEXT:    str q2, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt h2, d0
; WINDOWS-NEXT:    add x0, sp, #60
; WINDOWS-NEXT:    mov h1, v1.h[3]
; WINDOWS-NEXT:    fcvt d0, h1
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov v1.h[2], v2.h[0]
; WINDOWS-NEXT:    str q1, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt h1, d0
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; WINDOWS-NEXT:    mov v0.h[3], v1.h[0]
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #64
; WINDOWS-NEXT:    ret
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.0 = extractvalue { <2 x half>, <2 x i32> } %result, 0
  ret <2 x half> %result.0
}

define <2 x i32> @test_frexp_v2f16_v2i32_only_use_exp(<2 x half> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #24
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #28
; CHECK-NEXT:    add x19, sp, #28
; CHECK-NEXT:    mov h0, v0.h[1]
; CHECK-NEXT:    fcvt s0, h0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s0, [sp, #24]
; CHECK-NEXT:    ld1 { v0.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f16_v2i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #48
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    fcvt d0, h0
; WINDOWS-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    add x19, sp, #28
; WINDOWS-NEXT:    mov h0, v0.h[1]
; WINDOWS-NEXT:    fcvt d0, h0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s0, [sp, #24]
; WINDOWS-NEXT:    ld1 { v0.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #48
; WINDOWS-NEXT:    ret
  %result = call { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half> %a)
  %result.1 = extractvalue { <2 x half>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { <3 x float>, <3 x i32> } @test_frexp_v3f32_v3i32(<3 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v3f32_v3i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    add x0, sp, #56
; CHECK-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    add x19, sp, #56
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #60
; CHECK-NEXT:    add x20, sp, #60
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    mov v2.s[2], v0.s[0]
; CHECK-NEXT:    ld1 { v1.s }[2], [x20]
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    add sp, sp, #80
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v3f32_v3i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #80
; WINDOWS-NEXT:    mov s1, v0.s[1]
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #36
; WINDOWS-NEXT:    stp x30, x21, [sp, #48] // 16-byte Folded Spill
; WINDOWS-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x19, sp, #36
; WINDOWS-NEXT:    fcvt d0, s1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    add x0, sp, #32
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    add x20, sp, #40
; WINDOWS-NEXT:    mov v0.s[1], v1.s[0]
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[2]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    add x21, sp, #44
; WINDOWS-NEXT:    mov v1.s[2], v0.s[0]
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[3]
; WINDOWS-NEXT:    str q1, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s1, [sp, #32]
; WINDOWS-NEXT:    fcvt s2, d0
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[1], [x19]
; WINDOWS-NEXT:    mov v0.s[3], v2.s[0]
; WINDOWS-NEXT:    ld1 { v1.s }[2], [x20]
; WINDOWS-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[3], [x21]
; WINDOWS-NEXT:    ldp x30, x21, [sp, #48] // 16-byte Folded Reload
; WINDOWS-NEXT:    add sp, sp, #80
; WINDOWS-NEXT:    ret
  %result = call { <3 x float>, <3 x i32> } @llvm.frexp.v3f32.v3i32(<3 x float> %a)
  ret { <3 x float>, <3 x i32> } %result
}

define { float, i32 } @test_frexp_f32_i32(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f32_i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define { float, i32 } @test_frexp_f32_i32_tailcall(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_tailcall:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f32_i32_tailcall:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = tail call { float, i32 } @llvm.frexp.f32.i32(float %a)
  ret { float, i32 } %result
}

define float @test_frexp_f32_i32_only_use_fract(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f32_i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 0
  ret float %result.0
}

define i32 @test_frexp_f32_i32_only_use_exp(float %a) nounwind {
; CHECK-LABEL: test_frexp_f32_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f32_i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { float, i32 } @llvm.frexp.f32.i32(float %a)
  %result.0 = extractvalue { float, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x float>, <2 x i32> } @test_frexp_v2f32_v2i32(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    add x19, sp, #40
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.s[1], v2.s[0]
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f32_v2i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #48
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    mov s1, v0.s[1]
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x19, sp, #28
; WINDOWS-NEXT:    fcvt d0, s1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    fcvt d1, s1
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fmov d0, d1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr s1, [sp, #24]
; WINDOWS-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d1 killed $d1 killed $q1
; WINDOWS-NEXT:    mov v0.s[1], v2.s[0]
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #48
; WINDOWS-NEXT:    ret
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  ret { <2 x float>, <2 x i32> } %result
}

define <2 x float> @test_frexp_v2f32_v2i32_only_use_fract(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f32_v2i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #32
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    mov s1, v0.s[1]
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    str x30, [sp, #16] // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    fcvt d1, s1
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fmov d0, d1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ldr x30, [sp, #16] // 8-byte Folded Reload
; WINDOWS-NEXT:    mov v0.s[1], v1.s[0]
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #32
; WINDOWS-NEXT:    ret
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.0 = extractvalue { <2 x float>, <2 x i32> } %result, 0
  ret <2 x float> %result.0
}

define <2 x i32> @test_frexp_v2f32_v2i32_only_use_exp(<2 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    add x0, sp, #28
; CHECK-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #24
; CHECK-NEXT:    add x19, sp, #24
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s0, [sp, #28]
; CHECK-NEXT:    ld1 { v0.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f32_v2i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #48
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    add x19, sp, #28
; WINDOWS-NEXT:    mov s0, v0.s[1]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s0, [sp, #24]
; WINDOWS-NEXT:    ld1 { v0.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #48
; WINDOWS-NEXT:    ret
  %result = call { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float> %a)
  %result.1 = extractvalue { <2 x float>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

define { <4 x float>, <4 x i32> } @test_frexp_v4f32_v4i32(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #80
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    stp x30, x21, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; CHECK-NEXT:    add x19, sp, #40
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #36
; CHECK-NEXT:    add x20, sp, #36
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #32
; CHECK-NEXT:    add x21, sp, #32
; CHECK-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[3]
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    mov v2.s[3], v0.s[0]
; CHECK-NEXT:    ld1 { v1.s }[2], [x20]
; CHECK-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.16b, v2.16b
; CHECK-NEXT:    ld1 { v1.s }[3], [x21]
; CHECK-NEXT:    ldp x30, x21, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #80
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v4f32_v4i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #80
; WINDOWS-NEXT:    mov s1, v0.s[1]
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #36
; WINDOWS-NEXT:    stp x30, x21, [sp, #48] // 16-byte Folded Spill
; WINDOWS-NEXT:    stp x20, x19, [sp, #64] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x19, sp, #36
; WINDOWS-NEXT:    fcvt d0, s1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    add x0, sp, #32
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    add x20, sp, #40
; WINDOWS-NEXT:    mov v0.s[1], v1.s[0]
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[2]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    add x21, sp, #44
; WINDOWS-NEXT:    mov v1.s[2], v0.s[0]
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[3]
; WINDOWS-NEXT:    str q1, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s1, [sp, #32]
; WINDOWS-NEXT:    fcvt s2, d0
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[1], [x19]
; WINDOWS-NEXT:    mov v0.s[3], v2.s[0]
; WINDOWS-NEXT:    ld1 { v1.s }[2], [x20]
; WINDOWS-NEXT:    ldp x20, x19, [sp, #64] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v1.s }[3], [x21]
; WINDOWS-NEXT:    ldp x30, x21, [sp, #48] // 16-byte Folded Reload
; WINDOWS-NEXT:    add sp, sp, #80
; WINDOWS-NEXT:    ret
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  ret { <4 x float>, <4 x i32> } %result
}

define <4 x float> @test_frexp_v4f32_v4i32_only_use_fract(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    add x0, sp, #56
; CHECK-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #60
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    mov v0.s[1], v1.s[0]
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    mov v1.s[2], v0.s[0]
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    mov s0, v0.s[3]
; CHECK-NEXT:    str q1, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $s0 killed $s0 def $q0
; CHECK-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; CHECK-NEXT:    mov v1.s[3], v0.s[0]
; CHECK-NEXT:    mov v0.16b, v1.16b
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v4f32_v4i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #64
; WINDOWS-NEXT:    mov s1, v0.s[1]
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    str x30, [sp, #48] // 8-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s1
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #56
; WINDOWS-NEXT:    mov v0.s[1], v1.s[0]
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[2]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s0, d0
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #60
; WINDOWS-NEXT:    mov v1.s[2], v0.s[0]
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov s0, v0.s[3]
; WINDOWS-NEXT:    str q1, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    fcvt s1, d0
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    ldr x30, [sp, #48] // 8-byte Folded Reload
; WINDOWS-NEXT:    mov v0.s[3], v1.s[0]
; WINDOWS-NEXT:    add sp, sp, #64
; WINDOWS-NEXT:    ret
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.0 = extractvalue { <4 x float>, <4 x i32> } %result, 0
  ret <4 x float> %result.0
}

define <4 x i32> @test_frexp_v4f32_v4i32_only_use_exp(<4 x float> %a) nounwind {
; CHECK-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    add x0, sp, #28
; CHECK-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $s0 killed $s0 killed $q0
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #24
; CHECK-NEXT:    add x19, sp, #24
; CHECK-NEXT:    mov s0, v0.s[1]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #20
; CHECK-NEXT:    add x20, sp, #20
; CHECK-NEXT:    mov s0, v0.s[2]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #16
; CHECK-NEXT:    add x21, sp, #16
; CHECK-NEXT:    mov s0, v0.s[3]
; CHECK-NEXT:    bl frexpf
; CHECK-NEXT:    ldr s0, [sp, #28]
; CHECK-NEXT:    ld1 { v0.s }[1], [x19]
; CHECK-NEXT:    ld1 { v0.s }[2], [x20]
; CHECK-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    ld1 { v0.s }[3], [x21]
; CHECK-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v4f32_v4i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #64
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    add x0, sp, #16
; WINDOWS-NEXT:    stp x30, x21, [sp, #32] // 16-byte Folded Spill
; WINDOWS-NEXT:    stp x20, x19, [sp, #48] // 16-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #20
; WINDOWS-NEXT:    add x19, sp, #20
; WINDOWS-NEXT:    mov s0, v0.s[1]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    add x20, sp, #24
; WINDOWS-NEXT:    mov s0, v0.s[2]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    add x21, sp, #28
; WINDOWS-NEXT:    mov s0, v0.s[3]
; WINDOWS-NEXT:    fcvt d0, s0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s0, [sp, #16]
; WINDOWS-NEXT:    ld1 { v0.s }[1], [x19]
; WINDOWS-NEXT:    ld1 { v0.s }[2], [x20]
; WINDOWS-NEXT:    ldp x20, x19, [sp, #48] // 16-byte Folded Reload
; WINDOWS-NEXT:    ld1 { v0.s }[3], [x21]
; WINDOWS-NEXT:    ldp x30, x21, [sp, #32] // 16-byte Folded Reload
; WINDOWS-NEXT:    add sp, sp, #64
; WINDOWS-NEXT:    ret
  %result = call { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float> %a)
  %result.1 = extractvalue { <4 x float>, <4 x i32> } %result, 1
  ret <4 x i32> %result.1
}

define { double, i32 } @test_frexp_f64_i32(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f64_i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  ret { double, i32 } %result
}

define double @test_frexp_f64_i32_only_use_fract(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f64_i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 0
  ret double %result.0
}

define i32 @test_frexp_f64_i32_only_use_exp(double %a) nounwind {
; CHECK-LABEL: test_frexp_f64_i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #12
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr w0, [sp, #12]
; CHECK-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_f64_i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    str x30, [sp, #-16]! // 8-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #12
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr w0, [sp, #12]
; WINDOWS-NEXT:    ldr x30, [sp], #16 // 8-byte Folded Reload
; WINDOWS-NEXT:    ret
  %result = call { double, i32 } @llvm.frexp.f64.i32(double %a)
  %result.0 = extractvalue { double, i32 } %result, 1
  ret i32 %result.0
}

define { <2 x double>, <2 x i32> } @test_frexp_v2f64_v2i32(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #64
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; CHECK-NEXT:    add x19, sp, #40
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr s1, [sp, #44]
; CHECK-NEXT:    ldr q2, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ld1 { v1.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v2.d[0]
; CHECK-NEXT:    // kill: def $d1 killed $d1 killed $q1
; CHECK-NEXT:    add sp, sp, #64
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f64_v2i32:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #64
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    mov d0, v0.d[1]
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    stp x30, x19, [sp, #48] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x19, sp, #40
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s1, [sp, #44]
; WINDOWS-NEXT:    ldr q2, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    ld1 { v1.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #48] // 16-byte Folded Reload
; WINDOWS-NEXT:    mov v0.d[1], v2.d[0]
; WINDOWS-NEXT:    // kill: def $d1 killed $d1 killed $q1
; WINDOWS-NEXT:    add sp, sp, #64
; WINDOWS-NEXT:    ret
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  ret { <2 x double>, <2 x i32> } %result
}

define <2 x double> @test_frexp_v2f64_v2i32_only_use_fract(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    add x0, sp, #40
; CHECK-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    add x0, sp, #44
; CHECK-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 def $q0
; CHECK-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; CHECK-NEXT:    mov v0.d[1], v1.d[0]
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f64_v2i32_only_use_fract:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #48
; WINDOWS-NEXT:    str q0, [sp, #16] // 16-byte Folded Spill
; WINDOWS-NEXT:    mov d0, v0.d[1]
; WINDOWS-NEXT:    add x0, sp, #40
; WINDOWS-NEXT:    str x30, [sp, #32] // 8-byte Folded Spill
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    add x0, sp, #44
; WINDOWS-NEXT:    ldr q0, [sp, #16] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q1, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 def $q0
; WINDOWS-NEXT:    ldr x30, [sp, #32] // 8-byte Folded Reload
; WINDOWS-NEXT:    mov v0.d[1], v1.d[0]
; WINDOWS-NEXT:    add sp, sp, #48
; WINDOWS-NEXT:    ret
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.0 = extractvalue { <2 x double>, <2 x i32> } %result, 0
  ret <2 x double> %result.0
}

define <2 x i32> @test_frexp_v2f64_v2i32_only_use_exp(<2 x double> %a) nounwind {
; CHECK-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; CHECK:       // %bb.0:
; CHECK-NEXT:    sub sp, sp, #48
; CHECK-NEXT:    add x0, sp, #28
; CHECK-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; CHECK-NEXT:    str q0, [sp] // 16-byte Folded Spill
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; CHECK-NEXT:    add x0, sp, #24
; CHECK-NEXT:    add x19, sp, #24
; CHECK-NEXT:    mov d0, v0.d[1]
; CHECK-NEXT:    bl frexp
; CHECK-NEXT:    ldr s0, [sp, #28]
; CHECK-NEXT:    ld1 { v0.s }[1], [x19]
; CHECK-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; CHECK-NEXT:    // kill: def $d0 killed $d0 killed $q0
; CHECK-NEXT:    add sp, sp, #48
; CHECK-NEXT:    ret
;
; WINDOWS-LABEL: test_frexp_v2f64_v2i32_only_use_exp:
; WINDOWS:       // %bb.0:
; WINDOWS-NEXT:    sub sp, sp, #48
; WINDOWS-NEXT:    add x0, sp, #28
; WINDOWS-NEXT:    stp x30, x19, [sp, #32] // 16-byte Folded Spill
; WINDOWS-NEXT:    str q0, [sp] // 16-byte Folded Spill
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr q0, [sp] // 16-byte Folded Reload
; WINDOWS-NEXT:    add x0, sp, #24
; WINDOWS-NEXT:    add x19, sp, #24
; WINDOWS-NEXT:    mov d0, v0.d[1]
; WINDOWS-NEXT:    bl frexp
; WINDOWS-NEXT:    ldr s0, [sp, #28]
; WINDOWS-NEXT:    ld1 { v0.s }[1], [x19]
; WINDOWS-NEXT:    ldp x30, x19, [sp, #32] // 16-byte Folded Reload
; WINDOWS-NEXT:    // kill: def $d0 killed $d0 killed $q0
; WINDOWS-NEXT:    add sp, sp, #48
; WINDOWS-NEXT:    ret
  %result = call { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double> %a)
  %result.1 = extractvalue { <2 x double>, <2 x i32> } %result, 1
  ret <2 x i32> %result.1
}

declare { float, i32 } @llvm.frexp.f32.i32(float) #0
declare { <2 x float>, <2 x i32> } @llvm.frexp.v2f32.v2i32(<2 x float>) #0
declare { <4 x float>, <4 x i32> } @llvm.frexp.v4f32.v4i32(<4 x float>) #0

declare { half, i32 } @llvm.frexp.f16.i32(half) #0
declare { <2 x half>, <2 x i32> } @llvm.frexp.v2f16.v2i32(<2 x half>) #0

declare { double, i32 } @llvm.frexp.f64.i32(double) #0
declare { <2 x double>, <2 x i32> } @llvm.frexp.v2f64.v2i32(<2 x double>) #0

declare { half, i16 } @llvm.frexp.f16.i16(half) #0
declare { <2 x half>, <2 x i16> } @llvm.frexp.v2f16.v2i16(<2 x half>) #0

attributes #0 = { nocallback nofree nosync nounwind speculatable willreturn memory(none) }
