; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -verify-machineinstrs -force-streaming < %s | FileCheck %s

target triple = "aarch64-linux"


define void @test_write_zt_i8_0(<vscale x 16 x i8> %zn) #0 {
; CHECK-LABEL: test_write_zt_i8_0:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv16i8(i32 0, <vscale x 16 x i8> %zn, i32 0)
 ret void
}

define void @test_write_zt_i8_1(<vscale x 16 x i8> %zn) #0 {
; CHECK-LABEL: test_write_zt_i8_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[1, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv16i8(i32 0, <vscale x 16 x i8> %zn, i32 1)
 ret void
}

define void @test_write_zt_i16_2(<vscale x 8 x i16> %zn) #0 {
; CHECK-LABEL: test_write_zt_i16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[2, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv8i16(i32 0, <vscale x 8 x i16> %zn, i32 2)
 ret void
}

define void @test_write_zt_i32_3(<vscale x 4 x i32> %zn) #0 {
; CHECK-LABEL: test_write_zt_i32_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[3, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv4i32(i32 0, <vscale x 4 x i32> %zn, i32 3)
 ret void
}

define void @test_write_zt_i64_1(<vscale x 2 x i64> %zn) #0 {
; CHECK-LABEL: test_write_zt_i64_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[1, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv2i64(i32 0, <vscale x 2 x i64> %zn, i32 1)
 ret void
}

define void @test_write_zt_f16_2(<vscale x 8 x half> %zn) #0 {
; CHECK-LABEL: test_write_zt_f16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[2, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv8f16(i32 0, <vscale x 8 x half> %zn, i32 2)
 ret void
}

define void @test_write_zt_f32_3(<vscale x 4 x float> %zn) #0 {
; CHECK-LABEL: test_write_zt_f32_3:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[3, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv4f32(i32 0, <vscale x 4 x float> %zn, i32 3)
 ret void
}

define void @test_write_zt_f64_1(<vscale x 2 x double> %zn) #0 {
; CHECK-LABEL: test_write_zt_f64_1:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[1, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv2f64(i32 0, <vscale x 2 x double> %zn, i32 1)
 ret void
}

define void @test_write_zt_bf16_2(<vscale x 8 x bfloat> %zn) #0 {
; CHECK-LABEL: test_write_zt_bf16_2:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0[2, mul vl], z0
; CHECK-NEXT:    ret
 call void @llvm.aarch64.sme.write.lane.zt.nxv8bf16(i32 0, <vscale x 8 x bfloat> %zn, i32 2)
 ret void
}

;; ALIAS

define void @test_write_zt_i8(<vscale x 16 x i8> %v) #0 {
; CHECK-LABEL: test_write_zt_i8:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv16i8(i32 0, <vscale x 16 x i8> %v)
  ret void
}

define void @test_write_zt_i16(<vscale x 8 x i16> %v) #0 {
; CHECK-LABEL: test_write_zt_i16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv8i16(i32 0, <vscale x 8 x i16> %v)
  ret void
}

define void @test_write_zt_i32(<vscale x 4 x i32> %v) #0 {
; CHECK-LABEL: test_write_zt_i32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv4i32(i32 0, <vscale x 4 x i32> %v)
  ret void
}

define void @test_write_zt_i64(<vscale x 2 x i64> %v) #0 {
; CHECK-LABEL: test_write_zt_i64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv2i64(i32 0, <vscale x 2 x i64> %v)
  ret void
}

define void @test_write_zt_f16(<vscale x 8 x half> %v) #0 {
; CHECK-LABEL: test_write_zt_f16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv8f16(i32 0, <vscale x 8 x half> %v)
  ret void
}

define void @test_write_zt_bf16(<vscale x 8 x bfloat> %v) #0 {
; CHECK-LABEL: test_write_zt_bf16:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv8bf16(i32 0, <vscale x 8 x bfloat> %v)
  ret void
}

define void @test_write_zt_f32(<vscale x 4 x float> %v) #0 {
; CHECK-LABEL: test_write_zt_f32:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv4f32(i32 0, <vscale x 4 x float> %v)
  ret void
}

define void @test_write_zt_f64(<vscale x 2 x double> %v) #0 {
; CHECK-LABEL: test_write_zt_f64:
; CHECK:       // %bb.0:
; CHECK-NEXT:    movt zt0, z0
; CHECK-NEXT:    ret
  tail call void @llvm.aarch64.sme.write.zt.nxv2f64(i32 0, <vscale x 2 x double> %v)
  ret void
}

attributes #0 = { "target-features"="+sme2,+sme-lutv2" }
