; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc < %s -verify-machineinstrs -mcpu=sm_50 | FileCheck %s
; RUN: %if ptxas %{ llc < %s -verify-machineinstrs -mcpu=sm_50 | %ptxas-verify %}

target triple = "nvptx64-nvidia-cuda"

define i32 @test_prmt_basic(i32 %lo, i32 %hi, i32 %selector) {
; CHECK-LABEL: test_prmt_basic(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_basic_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_basic_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [test_prmt_basic_param_2];
; CHECK-NEXT:    prmt.b32 %r4, %r1, %r2, %r3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
    %val = call i32 @llvm.nvvm.prmt(i32 %lo, i32 %hi, i32 %selector)
    ret i32 %val
}

define i32 @test_prmt_f4e(i32 %lo, i32 %hi, i32 %selector) {
; CHECK-LABEL: test_prmt_f4e(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_f4e_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_f4e_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [test_prmt_f4e_param_2];
; CHECK-NEXT:    prmt.b32.f4e %r4, %r1, %r2, %r3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.f4e(i32 %lo, i32 %hi, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_b4e(i32 %lo, i32 %hi, i32 %selector) {
; CHECK-LABEL: test_prmt_b4e(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_b4e_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_b4e_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [test_prmt_b4e_param_2];
; CHECK-NEXT:    prmt.b32.b4e %r4, %r1, %r2, %r3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.b4e(i32 %lo, i32 %hi, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_rc8(i32 %lo, i32 %selector) {
; CHECK-LABEL: test_prmt_rc8(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_rc8_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_rc8_param_1];
; CHECK-NEXT:    prmt.b32.rc8 %r3, %r1, 0, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.rc8(i32 %lo, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_ecl(i32 %lo, i32 %selector) {
; CHECK-LABEL: test_prmt_ecl(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_ecl_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_ecl_param_1];
; CHECK-NEXT:    prmt.b32.ecl %r3, %r1, 0, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.ecl(i32 %lo, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_ecr(i32 %lo, i32 %selector) {
; CHECK-LABEL: test_prmt_ecr(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_ecr_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_ecr_param_1];
; CHECK-NEXT:    prmt.b32.ecr %r3, %r1, 0, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.ecr(i32 %lo, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_rc16(i32 %lo, i32 %selector) {
; CHECK-LABEL: test_prmt_rc16(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<4>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_rc16_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_rc16_param_1];
; CHECK-NEXT:    prmt.b32.rc16 %r3, %r1, 0, %r2;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r3;
; CHECK-NEXT:    ret;
  %val = call i32 @llvm.nvvm.prmt.rc16(i32 %lo, i32 %selector)
  ret i32 %val
}

define i32 @test_prmt_f4e_folding(i32 %lo, i32 %hi, i32 %ptr) {
; CHECK-LABEL: test_prmt_f4e_folding(
; CHECK:       {
; CHECK-NEXT:    .reg .b32 %r<5>;
; CHECK-EMPTY:
; CHECK-NEXT:  // %bb.0:
; CHECK-NEXT:    ld.param.b32 %r1, [test_prmt_f4e_folding_param_0];
; CHECK-NEXT:    ld.param.b32 %r2, [test_prmt_f4e_folding_param_1];
; CHECK-NEXT:    ld.param.b32 %r3, [test_prmt_f4e_folding_param_2];
; CHECK-NEXT:    prmt.b32.f4e %r4, %r1, %r2, %r3;
; CHECK-NEXT:    st.param.b32 [func_retval0], %r4;
; CHECK-NEXT:    ret;
  %sh_amt = shl i32 %ptr, 3
  %val = call i32 @llvm.fshr.i32(i32 %hi, i32 %lo, i32 %sh_amt)
  ret i32 %val
}
