; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; FIXME: @llvm.canonicalize doesn't support soft-float abi yet.
; RUN: llc --mtriple=riscv64 --mattr=+d,+zfh < %s | FileCheck %s --check-prefixes=CHECK,CHECK-FP16-RV64
; RUN: llc --mtriple=riscv64 --mattr=+d,-zfh < %s | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16-RV64
; RUN: llc --mtriple=riscv32 --mattr=+d,+zfh < %s | FileCheck %s --check-prefixes=CHECK,CHECK-FP16-RV32
; RUN: llc --mtriple=riscv32 --mattr=+d,-zfh < %s | FileCheck %s --check-prefixes=CHECK,CHECK-NOFP16-RV32

declare half @llvm.fcanonicalize.f16(half)
declare float @llvm.fcanonicalize.f32(float)
declare double @llvm.fcanonicalize.f64(double)

define half @fcanonicalize_f16(half %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_f16:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_f16:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV64-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    lui a1, 1048560
; CHECK-NOFP16-RV64-NEXT:    or a0, a0, a1
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV64-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_f16:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_f16:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    lui a1, 1048560
; CHECK-NOFP16-RV32-NEXT:    or a0, a0, a1
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call half @llvm.canonicalize.f16(half %x)
  ret half %z
}

define half @fcanonicalize_f16_nnan(half %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_f16_nnan:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_f16_nnan:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV64-NEXT:    sd ra, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    lui a1, 1048560
; CHECK-NOFP16-RV64-NEXT:    or a0, a0, a1
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV64-NEXT:    ld ra, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_f16_nnan:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_f16_nnan:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    lui a1, 1048560
; CHECK-NOFP16-RV32-NEXT:    or a0, a0, a1
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call nnan half @llvm.canonicalize.f16(half %x)
  ret half %z
}

define <2 x half> @fcanonicalize_v2f16(<2 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v2f16:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v2f16:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOFP16-RV64-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    mv s0, a1
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s0
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a1, fa0
; CHECK-NOFP16-RV64-NEXT:    mv a0, s1
; CHECK-NOFP16-RV64-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 32
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v2f16:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v2f16:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -16
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a1
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s0, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a1, fa0
; CHECK-NOFP16-RV32-NEXT:    mv a0, s0
; CHECK-NOFP16-RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call <2 x half> @llvm.canonicalize.v2f16(<2 x half> %x)
  ret <2 x half> %z
}

define <2 x half> @fcanonicalize_v2f16_nnan(<2 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 32
; CHECK-NOFP16-RV64-NEXT:    sd ra, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    mv s0, a1
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s0
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a1, fa0
; CHECK-NOFP16-RV64-NEXT:    mv a0, s1
; CHECK-NOFP16-RV64-NEXT:    ld ra, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 32
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v2f16_nnan:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 16
; CHECK-NOFP16-RV32-NEXT:    sw ra, 12(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 8(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -16
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a1
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s0, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a1, fa0
; CHECK-NOFP16-RV32-NEXT:    mv a0, s0
; CHECK-NOFP16-RV32-NEXT:    lw ra, 12(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 8(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 16
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call nnan <2 x half> @llvm.canonicalize.v2f16(<2 x half> %x)
  ret <2 x half> %z
}

define <4 x half> @fcanonicalize_v4f16(<4 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v4f16:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa5, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa4, fa1, fa1
; CHECK-FP16-RV64-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV64-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV64-NEXT:    fsh fa5, 0(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa4, 2(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v4f16:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -64
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOFP16-RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs0, -48
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs1, -56
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs2, -64
; CHECK-NOFP16-RV64-NEXT:    lhu s1, 0(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s2, 8(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s3, 16(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu a1, 24(a1)
; CHECK-NOFP16-RV64-NEXT:    mv s0, a0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs0, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s3
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s2
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s2, fs2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fs0, fs0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s3, fs1
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV64-NEXT:    sh a0, 6(s0)
; CHECK-NOFP16-RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 64
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v4f16:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa5, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa4, fa1, fa1
; CHECK-FP16-RV32-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV32-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV32-NEXT:    fsh fa5, 0(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa4, 2(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v4f16:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -64
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOFP16-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s1, 52(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s2, 48(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s3, 44(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs1, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs2, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs3, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -32
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs1, -40
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs2, -48
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs3, -56
; CHECK-NOFP16-RV32-NEXT:    mv s0, a0
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 0(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 4(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 8(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a1, 12(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs1, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs2, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs2
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s2, fs1
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fs3, fs3
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s3, fs2
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV32-NEXT:    sh a0, 6(s0)
; CHECK-NOFP16-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s1, 52(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s2, 48(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s3, 44(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs1, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs2, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs3, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 64
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call <4 x half> @llvm.canonicalize.v4f16(<4 x half> %x)
  ret <4 x half> %z
}

define <4 x half> @fcanonicalize_v4f16_nnan(<4 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa5, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa4, fa1, fa1
; CHECK-FP16-RV64-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV64-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV64-NEXT:    fsh fa5, 0(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa4, 2(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -64
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOFP16-RV64-NEXT:    sd ra, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s2, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s3, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs0, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs1, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs2, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs0, -48
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs1, -56
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs2, -64
; CHECK-NOFP16-RV64-NEXT:    lhu s1, 0(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s2, 8(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s3, 16(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu a1, 24(a1)
; CHECK-NOFP16-RV64-NEXT:    mv s0, a0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs0, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s3
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s2
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s2, fs2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fs0, fs0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s3, fs1
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV64-NEXT:    sh a0, 6(s0)
; CHECK-NOFP16-RV64-NEXT:    ld ra, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s2, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s3, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs0, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs1, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs2, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 64
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa5, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa4, fa1, fa1
; CHECK-FP16-RV32-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV32-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV32-NEXT:    fsh fa5, 0(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa4, 2(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v4f16_nnan:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -64
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 64
; CHECK-NOFP16-RV32-NEXT:    sw ra, 60(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 56(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s1, 52(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s2, 48(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s3, 44(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs1, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs2, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs3, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -32
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs1, -40
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs2, -48
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs3, -56
; CHECK-NOFP16-RV32-NEXT:    mv s0, a0
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 0(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 4(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 8(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a1, 12(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs1, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs2, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs2
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s2, fs1
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fs3, fs3
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s3, fs2
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV32-NEXT:    sh a0, 6(s0)
; CHECK-NOFP16-RV32-NEXT:    lw ra, 60(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 56(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s1, 52(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s2, 48(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s3, 44(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs1, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs2, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs3, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 64
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call nnan <4 x half> @llvm.canonicalize.v4f16(<4 x half> %x)
  ret <4 x half> %z
}

define <8 x half> @fcanonicalize_v8f16(<8 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v8f16:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV64-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV64-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV64-NEXT:    fmin.h fa4, fa4, fa4
; CHECK-FP16-RV64-NEXT:    fmin.h fa5, fa5, fa5
; CHECK-FP16-RV64-NEXT:    fmin.h ft0, fa6, fa6
; CHECK-FP16-RV64-NEXT:    fmin.h ft1, fa7, fa7
; CHECK-FP16-RV64-NEXT:    fsh fa4, 8(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa5, 10(a0)
; CHECK-FP16-RV64-NEXT:    fsh ft0, 12(a0)
; CHECK-FP16-RV64-NEXT:    fsh ft1, 14(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa0, 0(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa1, 2(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v8f16:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -128
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOFP16-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs0, -80
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs1, -88
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs2, -96
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs3, -104
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs4, -112
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs5, -120
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs6, -128
; CHECK-NOFP16-RV64-NEXT:    lhu s1, 0(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s2, 8(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s3, 16(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s4, 24(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s5, 32(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s6, 40(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s7, 48(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu a1, 56(a1)
; CHECK-NOFP16-RV64-NEXT:    mv s0, a0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs0, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s7
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s6
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s5
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s4
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs4, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s3
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs5, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s2
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs6, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s2, fs6
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s3, fs5
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s4, fs4
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s5, fs3
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s6, fs2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fs0, fs0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s7, fs1
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    sh s5, 8(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s6, 10(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s7, 12(s0)
; CHECK-NOFP16-RV64-NEXT:    sh a0, 14(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s4, 6(s0)
; CHECK-NOFP16-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s4
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s5
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s6
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s7
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs4
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs5
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs6
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 128
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v8f16:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV32-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV32-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV32-NEXT:    fmin.h fa4, fa4, fa4
; CHECK-FP16-RV32-NEXT:    fmin.h fa5, fa5, fa5
; CHECK-FP16-RV32-NEXT:    fmin.h ft0, fa6, fa6
; CHECK-FP16-RV32-NEXT:    fmin.h ft1, fa7, fa7
; CHECK-FP16-RV32-NEXT:    fsh fa4, 8(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa5, 10(a0)
; CHECK-FP16-RV32-NEXT:    fsh ft0, 12(a0)
; CHECK-FP16-RV32-NEXT:    fsh ft1, 14(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa0, 0(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa1, 2(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v8f16:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -112
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NOFP16-RV32-NEXT:    sw ra, 108(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 104(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s1, 100(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s2, 96(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s3, 92(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s4, 88(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s5, 84(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s6, 80(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s7, 76(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 64(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs1, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs2, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs3, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs4, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs5, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs6, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs7, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -48
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs1, -56
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs2, -64
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs3, -72
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs4, -80
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs5, -88
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs6, -96
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs7, -104
; CHECK-NOFP16-RV32-NEXT:    mv s0, a0
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 0(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 4(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 8(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a4, 12(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs2, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs4, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs5, a4
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 16(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 20(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 24(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a1, 28(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs6, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs7, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs3, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs3
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs7
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs7, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs6
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs6, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs5
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs5, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs4
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs4, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs2
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s2, fs2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s3, fs4
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s4, fs5
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s5, fs6
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s6, fs7
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fs1, fs1
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s7, fs3
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    sh s5, 8(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s6, 10(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s7, 12(s0)
; CHECK-NOFP16-RV32-NEXT:    sh a0, 14(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s4, 6(s0)
; CHECK-NOFP16-RV32-NEXT:    lw ra, 108(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 104(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s1, 100(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s2, 96(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s3, 92(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s4, 88(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s5, 84(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s6, 80(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s7, 76(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 64(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs1, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs2, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs3, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs4, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs5, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs6, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs7, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s4
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s5
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s6
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s7
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs4
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs5
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs6
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs7
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 112
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call <8 x half> @llvm.canonicalize.v8f16(<8 x half> %x)
  ret <8 x half> %z
}

define <8 x half> @fcanonicalize_v8f16_nnan(<8 x half> %x) {
; CHECK-FP16-RV64-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-FP16-RV64:       # %bb.0:
; CHECK-FP16-RV64-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV64-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV64-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV64-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV64-NEXT:    fmin.h fa4, fa4, fa4
; CHECK-FP16-RV64-NEXT:    fmin.h fa5, fa5, fa5
; CHECK-FP16-RV64-NEXT:    fmin.h ft0, fa6, fa6
; CHECK-FP16-RV64-NEXT:    fmin.h ft1, fa7, fa7
; CHECK-FP16-RV64-NEXT:    fsh fa4, 8(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa5, 10(a0)
; CHECK-FP16-RV64-NEXT:    fsh ft0, 12(a0)
; CHECK-FP16-RV64-NEXT:    fsh ft1, 14(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa0, 0(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa1, 2(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV64-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV64-NEXT:    ret
;
; CHECK-NOFP16-RV64-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-NOFP16-RV64:       # %bb.0:
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, -128
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 128
; CHECK-NOFP16-RV64-NEXT:    sd ra, 120(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s0, 112(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s1, 104(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s2, 96(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s3, 88(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s4, 80(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s5, 72(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s6, 64(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    sd s7, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs0, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs1, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs2, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs3, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs4, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs5, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    fsd fs6, 0(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset ra, -8
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s0, -16
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s1, -24
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s2, -32
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s3, -40
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s4, -48
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s5, -56
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s6, -64
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset s7, -72
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs0, -80
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs1, -88
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs2, -96
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs3, -104
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs4, -112
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs5, -120
; CHECK-NOFP16-RV64-NEXT:    .cfi_offset fs6, -128
; CHECK-NOFP16-RV64-NEXT:    lhu s1, 0(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s2, 8(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s3, 16(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s4, 24(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s5, 32(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s6, 40(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu s7, 48(a1)
; CHECK-NOFP16-RV64-NEXT:    lhu a1, 56(a1)
; CHECK-NOFP16-RV64-NEXT:    mv s0, a0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs0, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s7
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s6
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s5
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s4
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs4, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s3
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs5, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s2
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.s fs6, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.w.x fa0, s1
; CHECK-NOFP16-RV64-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s2, fs6
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s3, fs5
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s4, fs4
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s5, fs3
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s6, fs2
; CHECK-NOFP16-RV64-NEXT:    fmin.s fa0, fs0, fs0
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w s7, fs1
; CHECK-NOFP16-RV64-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV64-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV64-NEXT:    sh s5, 8(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s6, 10(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s7, 12(s0)
; CHECK-NOFP16-RV64-NEXT:    sh a0, 14(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV64-NEXT:    sh s4, 6(s0)
; CHECK-NOFP16-RV64-NEXT:    ld ra, 120(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s0, 112(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s1, 104(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s2, 96(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s3, 88(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s4, 80(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s5, 72(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s6, 64(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    ld s7, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs0, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs1, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs2, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs3, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs4, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs5, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    fld fs6, 0(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s4
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s5
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s6
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore s7
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs4
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs5
; CHECK-NOFP16-RV64-NEXT:    .cfi_restore fs6
; CHECK-NOFP16-RV64-NEXT:    addi sp, sp, 128
; CHECK-NOFP16-RV64-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV64-NEXT:    ret
;
; CHECK-FP16-RV32-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-FP16-RV32:       # %bb.0:
; CHECK-FP16-RV32-NEXT:    fmin.h fa0, fa0, fa0
; CHECK-FP16-RV32-NEXT:    fmin.h fa1, fa1, fa1
; CHECK-FP16-RV32-NEXT:    fmin.h fa2, fa2, fa2
; CHECK-FP16-RV32-NEXT:    fmin.h fa3, fa3, fa3
; CHECK-FP16-RV32-NEXT:    fmin.h fa4, fa4, fa4
; CHECK-FP16-RV32-NEXT:    fmin.h fa5, fa5, fa5
; CHECK-FP16-RV32-NEXT:    fmin.h ft0, fa6, fa6
; CHECK-FP16-RV32-NEXT:    fmin.h ft1, fa7, fa7
; CHECK-FP16-RV32-NEXT:    fsh fa4, 8(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa5, 10(a0)
; CHECK-FP16-RV32-NEXT:    fsh ft0, 12(a0)
; CHECK-FP16-RV32-NEXT:    fsh ft1, 14(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa0, 0(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa1, 2(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa2, 4(a0)
; CHECK-FP16-RV32-NEXT:    fsh fa3, 6(a0)
; CHECK-FP16-RV32-NEXT:    ret
;
; CHECK-NOFP16-RV32-LABEL: fcanonicalize_v8f16_nnan:
; CHECK-NOFP16-RV32:       # %bb.0:
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, -112
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 112
; CHECK-NOFP16-RV32-NEXT:    sw ra, 108(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s0, 104(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s1, 100(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s2, 96(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s3, 92(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s4, 88(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s5, 84(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s6, 80(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    sw s7, 76(sp) # 4-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs0, 64(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs1, 56(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs2, 48(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs3, 40(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs4, 32(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs5, 24(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs6, 16(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    fsd fs7, 8(sp) # 8-byte Folded Spill
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset ra, -4
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s0, -8
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s1, -12
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s2, -16
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s3, -20
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s4, -24
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s5, -28
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s6, -32
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset s7, -36
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs0, -48
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs1, -56
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs2, -64
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs3, -72
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs4, -80
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs5, -88
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs6, -96
; CHECK-NOFP16-RV32-NEXT:    .cfi_offset fs7, -104
; CHECK-NOFP16-RV32-NEXT:    mv s0, a0
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 0(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 4(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 8(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a4, 12(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs0, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs2, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs4, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs5, a4
; CHECK-NOFP16-RV32-NEXT:    lhu a0, 16(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a2, 20(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a3, 24(a1)
; CHECK-NOFP16-RV32-NEXT:    lhu a1, 28(a1)
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs6, a0
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs7, a2
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fs3, a3
; CHECK-NOFP16-RV32-NEXT:    fmv.w.x fa0, a1
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs3
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs3, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs7
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs7, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs6
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs6, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs5
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs5, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs4
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs4, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs2
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.s fs2, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.s fa0, fs0
; CHECK-NOFP16-RV32-NEXT:    call __extendhfsf2
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s1, fa0
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s2, fs2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s3, fs4
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s4, fs5
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s5, fs6
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s6, fs7
; CHECK-NOFP16-RV32-NEXT:    fmin.s fa0, fs1, fs1
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w s7, fs3
; CHECK-NOFP16-RV32-NEXT:    call __truncsfhf2
; CHECK-NOFP16-RV32-NEXT:    fmv.x.w a0, fa0
; CHECK-NOFP16-RV32-NEXT:    sh s5, 8(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s6, 10(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s7, 12(s0)
; CHECK-NOFP16-RV32-NEXT:    sh a0, 14(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s1, 0(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s2, 2(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s3, 4(s0)
; CHECK-NOFP16-RV32-NEXT:    sh s4, 6(s0)
; CHECK-NOFP16-RV32-NEXT:    lw ra, 108(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s0, 104(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s1, 100(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s2, 96(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s3, 92(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s4, 88(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s5, 84(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s6, 80(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    lw s7, 76(sp) # 4-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs0, 64(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs1, 56(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs2, 48(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs3, 40(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs4, 32(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs5, 24(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs6, 16(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    fld fs7, 8(sp) # 8-byte Folded Reload
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore ra
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s4
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s5
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s6
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore s7
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs0
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs1
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs2
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs3
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs4
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs5
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs6
; CHECK-NOFP16-RV32-NEXT:    .cfi_restore fs7
; CHECK-NOFP16-RV32-NEXT:    addi sp, sp, 112
; CHECK-NOFP16-RV32-NEXT:    .cfi_def_cfa_offset 0
; CHECK-NOFP16-RV32-NEXT:    ret
  %z = call nnan <8 x half> @llvm.canonicalize.v8f16(<8 x half> %x)
  ret <8 x half> %z
}

define float @fcanonicalize_f32(float %x) {
; CHECK-LABEL: fcanonicalize_f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NEXT:    ret
  %z = call float @llvm.canonicalize.f32(float %x)
  ret float %z
}

define float @fcanonicalize_f32_nnan(float %x) {
; CHECK-LABEL: fcanonicalize_f32_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NEXT:    ret
  %z = call nnan float @llvm.canonicalize.f32(float %x)
  ret float %z
}

define <2 x float> @fcanonicalize_v2f32(<2 x float> %x) {
; CHECK-LABEL: fcanonicalize_v2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NEXT:    fmin.s fa1, fa1, fa1
; CHECK-NEXT:    ret
  %z = call <2 x float> @llvm.canonicalize.v2f32(<2 x float> %x)
  ret <2 x float> %z
}

define <2 x float> @fcanonicalize_v2f32_nnan(<2 x float> %x) {
; CHECK-LABEL: fcanonicalize_v2f32_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa0, fa0, fa0
; CHECK-NEXT:    fmin.s fa1, fa1, fa1
; CHECK-NEXT:    ret
  %z = call nnan <2 x float> @llvm.canonicalize.v2f32(<2 x float> %x)
  ret <2 x float> %z
}

define <4 x float> @fcanonicalize_v4f32(<4 x float> %x) {
; CHECK-LABEL: fcanonicalize_v4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa5, fa0, fa0
; CHECK-NEXT:    fmin.s fa4, fa1, fa1
; CHECK-NEXT:    fmin.s fa2, fa2, fa2
; CHECK-NEXT:    fmin.s fa3, fa3, fa3
; CHECK-NEXT:    fsw fa5, 0(a0)
; CHECK-NEXT:    fsw fa4, 4(a0)
; CHECK-NEXT:    fsw fa2, 8(a0)
; CHECK-NEXT:    fsw fa3, 12(a0)
; CHECK-NEXT:    ret
  %z = call <4 x float> @llvm.canonicalize.v4f32(<4 x float> %x)
  ret <4 x float> %z
}

define <4 x float> @fcanonicalize_v4f32_nnan(<4 x float> %x) {
; CHECK-LABEL: fcanonicalize_v4f32_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.s fa5, fa0, fa0
; CHECK-NEXT:    fmin.s fa4, fa1, fa1
; CHECK-NEXT:    fmin.s fa2, fa2, fa2
; CHECK-NEXT:    fmin.s fa3, fa3, fa3
; CHECK-NEXT:    fsw fa5, 0(a0)
; CHECK-NEXT:    fsw fa4, 4(a0)
; CHECK-NEXT:    fsw fa2, 8(a0)
; CHECK-NEXT:    fsw fa3, 12(a0)
; CHECK-NEXT:    ret
  %z = call nnan <4 x float> @llvm.canonicalize.v4f32(<4 x float> %x)
  ret <4 x float> %z
}

define double @fcanonicalize_f64(double %x) {
; CHECK-LABEL: fcanonicalize_f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.d fa0, fa0, fa0
; CHECK-NEXT:    ret
  %z = call double @llvm.canonicalize.f64(double %x)
  ret double %z
}

define double @fcanonicalize_f64_nnan(double %x) {
; CHECK-LABEL: fcanonicalize_f64_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.d fa0, fa0, fa0
; CHECK-NEXT:    ret
  %z = call nnan double @llvm.canonicalize.f64(double %x)
  ret double %z
}

define <2 x double> @fcanonicalize_v2f64(<2 x double> %x) {
; CHECK-LABEL: fcanonicalize_v2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.d fa0, fa0, fa0
; CHECK-NEXT:    fmin.d fa1, fa1, fa1
; CHECK-NEXT:    ret
  %z = call <2 x double> @llvm.canonicalize.v2f64(<2 x double> %x)
  ret <2 x double> %z
}

define <2 x double> @fcanonicalize_v2f64_nnan(<2 x double> %x) {
; CHECK-LABEL: fcanonicalize_v2f64_nnan:
; CHECK:       # %bb.0:
; CHECK-NEXT:    fmin.d fa0, fa0, fa0
; CHECK-NEXT:    fmin.d fa1, fa1, fa1
; CHECK-NEXT:    ret
  %z = call nnan <2 x double> @llvm.canonicalize.v2f64(<2 x double> %x)
  ret <2 x double> %z
}
