; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx512f,+avx512vl | FileCheck %s --check-prefixes=CHECK,AVX512
; RUN: llc < %s -mtriple=x86_64-- -mattr=+avx2 | FileCheck %s --check-prefixes=CHECK,AVX2
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse4.1 | FileCheck %s --check-prefixes=CHECK,SSE,SSE41
; RUN: llc < %s -mtriple=x86_64-- -mattr=+sse2 | FileCheck %s --check-prefixes=CHECK,SSE,SSE2

; Todo: Support logic for non-splat vectors
define <4 x i1> @andnot_eq_v4i32_todo_no_splat(<4 x i32> %x) nounwind {
; AVX512-LABEL: andnot_eq_v4i32_todo_no_splat:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %k1
; AVX512-NEXT:    korw %k1, %k0, %k1
; AVX512-NEXT:    vmovdqa32 %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_eq_v4i32_todo_no_splat:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_eq_v4i32_todo_no_splat:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp eq <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %cmp2 = icmp eq <4 x i32> %x, <i32 -9, i32 -17, i32 -5, i32 -129>
  %r = or <4 x i1> %cmp1, %cmp2
  ret <4 x i1> %r
}

define <4 x i1> @andnot_eq_v4i32(<4 x i32> %x) nounwind {
; AVX512-LABEL: andnot_eq_v4i32:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandnd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_eq_v4i32:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpbroadcastd {{.*#+}} xmm1 = [4294967287,4294967287,4294967287,4294967287]
; AVX2-NEXT:    vpandn %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_eq_v4i32:
; SSE:       # %bb.0:
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm1
; SSE-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp eq <4 x i32> %x, <i32 -1, i32 -1, i32 -1, i32 -1>
  %cmp2 = icmp eq <4 x i32> %x, <i32 -9, i32 -9, i32 -9, i32 -9>
  %r = or <4 x i1> %cmp1, %cmp2
  ret <4 x i1> %r
}

; Intentional negative test.
define <2 x i1> @andnot_eq_v2i64_fail_max_not_n1(<2 x i64> %x) nounwind {
; AVX512-LABEL: andnot_eq_v2i64_fail_max_not_n1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqq %xmm1, %xmm0, %k0
; AVX512-NEXT:    vpcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %k1
; AVX512-NEXT:    korw %k1, %k0, %k1
; AVX512-NEXT:    vmovdqa64 %xmm1, %xmm0 {%k1} {z}
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_eq_v2i64_fail_max_not_n1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: andnot_eq_v2i64_fail_max_not_n1:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqq {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: andnot_eq_v2i64_fail_max_not_n1:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm0, %xmm1
; SSE2-NEXT:    pshufd {{.*#+}} xmm2 = xmm1[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm2
; SSE2-NEXT:    pcmpeqd {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    por %xmm2, %xmm0
; SSE2-NEXT:    retq
  %cmp1 = icmp eq <2 x i64> %x, <i64 -1, i64 -1>
  %cmp2 = icmp eq <2 x i64> %x, <i64 7, i64 7>
  %r = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %r
}

define <2 x i1> @andnot_eq_v2i64(<2 x i64> %x) nounwind {
; AVX512-LABEL: andnot_eq_v2i64:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandnq {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to2}, %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_eq_v2i64:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqq %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: andnot_eq_v2i64:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    pxor %xmm1, %xmm1
; SSE41-NEXT:    pcmpeqq %xmm1, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: andnot_eq_v2i64:
; SSE2:       # %bb.0:
; SSE2-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    pxor %xmm1, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm1, %xmm0
; SSE2-NEXT:    pshufd {{.*#+}} xmm1 = xmm0[1,0,3,2]
; SSE2-NEXT:    pand %xmm1, %xmm0
; SSE2-NEXT:    retq
  %cmp1 = icmp eq <2 x i64> %x, <i64 -5, i64 -5>
  %cmp2 = icmp eq <2 x i64> %x, <i64 -1, i64 -1>
  %r = or <2 x i1> %cmp1, %cmp2
  ret <2 x i1> %r
}

; Todo: Support logic for non-splat vectors
define <8 x i1> @andnot_ne_v8i16_todo_no_splat(<8 x i16> %x) nounwind {
; AVX512-LABEL: andnot_ne_v8i16_todo_no_splat:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpternlogq $54, %xmm2, %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_ne_v8i16_todo_no_splat:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_ne_v8i16_todo_no_splat:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pcmpeqw %xmm1, %xmm2
; SSE-NEXT:    pcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp ne <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %cmp2 = icmp ne <8 x i16> %x, <i16 -16385, i16 -257, i16 -33, i16 -8193, i16 -16385, i16 -257, i16 -33, i16 -8193>
  %r = and <8 x i1> %cmp1, %cmp2
  ret <8 x i1> %r
}

define <8 x i1> @andnot_ne_v8i16(<8 x i16> %x) nounwind {
; AVX512-LABEL: andnot_ne_v8i16:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandnd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqw %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_ne_v8i16:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_ne_v8i16:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqw %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp ne <8 x i16> %x, <i16 -16385, i16 -16385, i16 -16385, i16 -16385, i16 -16385, i16 -16385, i16 -16385, i16 -16385>
  %cmp2 = icmp ne <8 x i16> %x, <i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1, i16 -1>
  %r = and <8 x i1> %cmp1, %cmp2
  ret <8 x i1> %r
}

; Intentional negative test.
define <16 x i1> @andnot_ne_v16i8_fail_max_not_n1(<16 x i8> %x) nounwind {
; AVX512-LABEL: andnot_ne_v16i8_fail_max_not_n1:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm2
; AVX512-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpternlogq $54, %xmm2, %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_ne_v16i8_fail_max_not_n1:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm2
; AVX2-NEXT:    vpcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm0, %xmm2, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_ne_v16i8_fail_max_not_n1:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    movdqa %xmm0, %xmm2
; SSE-NEXT:    pcmpeqb %xmm1, %xmm2
; SSE-NEXT:    pcmpgtb {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    por %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp ne <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %cmp2 = icmp ne <16 x i8> %x, <i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127, i8 127>
  %r = and <16 x i1> %cmp1, %cmp2
  ret <16 x i1> %r
}

define <16 x i1> @andnot_ne_v16i8(<16 x i8> %x) nounwind {
; AVX512-LABEL: andnot_ne_v16i8:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpandnd {{\.?LCPI[0-9]+_[0-9]+}}(%rip){1to4}, %xmm0, %xmm0
; AVX512-NEXT:    vpxor %xmm1, %xmm1, %xmm1
; AVX512-NEXT:    vpcmpeqb %xmm1, %xmm0, %xmm0
; AVX512-NEXT:    vpternlogq $15, %xmm0, %xmm0, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: andnot_ne_v16i8:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqd %xmm1, %xmm1, %xmm1
; AVX2-NEXT:    vpandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqb %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    vpxor %xmm1, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE-LABEL: andnot_ne_v16i8:
; SSE:       # %bb.0:
; SSE-NEXT:    pcmpeqd %xmm1, %xmm1
; SSE-NEXT:    pandn {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE-NEXT:    pxor %xmm2, %xmm2
; SSE-NEXT:    pcmpeqb %xmm2, %xmm0
; SSE-NEXT:    pxor %xmm1, %xmm0
; SSE-NEXT:    retq
  %cmp1 = icmp ne <16 x i8> %x, <i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1, i8 -1>
  %cmp2 = icmp ne <16 x i8> %x, <i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33, i8 -33>
  %r = and <16 x i1> %cmp1, %cmp2
  ret <16 x i1> %r
}

define i1 @andnot_ne_i32(i32 %x) nounwind {
; CHECK-LABEL: andnot_ne_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addl $1073741825, %edi # imm = 0x40000001
; CHECK-NEXT:    testl $-1073741825, %edi # imm = 0xBFFFFFFF
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %cmp1 = icmp ne i32 %x, -1
  %cmp2 = icmp ne i32 %x, -1073741825
  %r = and i1 %cmp1, %cmp2
  ret i1 %r
}

define i1 @addand_ne_i16(i16 %x) nounwind {
; CHECK-LABEL: addand_ne_i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addl $3, %edi
; CHECK-NEXT:    testl $49151, %edi # imm = 0xBFFF
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %cmp1 = icmp ne i16 %x, -3
  %cmp2 = icmp ne i16 %x, 16381
  %r = and i1 %cmp1, %cmp2
  ret i1 %r
}

; Intentional negative test.
define <8 x i1> @addand_ne_v8i16_fail(<8 x i16> %x) nounwind {
; AVX512-LABEL: addand_ne_v8i16_fail:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX512-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX512-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX512-NEXT:    vpternlogq $86, %xmm2, %xmm1, %xmm0
; AVX512-NEXT:    retq
;
; AVX2-LABEL: addand_ne_v8i16_fail:
; AVX2:       # %bb.0:
; AVX2-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm1
; AVX2-NEXT:    vpcmpeqd %xmm2, %xmm2, %xmm2
; AVX2-NEXT:    vpcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0, %xmm0
; AVX2-NEXT:    vpor %xmm0, %xmm1, %xmm0
; AVX2-NEXT:    vpxor %xmm2, %xmm0, %xmm0
; AVX2-NEXT:    retq
;
; SSE41-LABEL: addand_ne_v8i16_fail:
; SSE41:       # %bb.0:
; SSE41-NEXT:    pmovsxbw {{.*#+}} xmm1 = [65533,65533,65533,65533,65533,65533,65533,65533]
; SSE41-NEXT:    pcmpeqw %xmm0, %xmm1
; SSE41-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE41-NEXT:    pcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE41-NEXT:    por %xmm1, %xmm0
; SSE41-NEXT:    pxor %xmm2, %xmm0
; SSE41-NEXT:    retq
;
; SSE2-LABEL: addand_ne_v8i16_fail:
; SSE2:       # %bb.0:
; SSE2-NEXT:    movdqa {{.*#+}} xmm1 = [65533,65533,65533,65533,65533,65533,65533,65533]
; SSE2-NEXT:    pcmpeqw %xmm0, %xmm1
; SSE2-NEXT:    pcmpeqd %xmm2, %xmm2
; SSE2-NEXT:    pcmpeqw {{\.?LCPI[0-9]+_[0-9]+}}(%rip), %xmm0
; SSE2-NEXT:    por %xmm1, %xmm0
; SSE2-NEXT:    pxor %xmm2, %xmm0
; SSE2-NEXT:    retq
  %cmp1 = icmp ne <8 x i16> %x, <i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3, i16 -3>
  %cmp2 = icmp ne <8 x i16> %x, <i16 16381, i16 16381, i16 16381, i16 16381, i16 16381, i16 16381, i16 16381, i16 16381>
  %r = and <8 x i1> %cmp1, %cmp2
  ret <8 x i1> %r
}

define i1 @addand_eq_i32(i32 %x) nounwind {
; CHECK-LABEL: addand_eq_i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    incl %edi
; CHECK-NEXT:    testl $-9, %edi
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    retq
  %cmp1 = icmp eq i32 %x, -1
  %cmp2 = icmp eq i32 %x, 7
  %r = or i1 %cmp1, %cmp2
  ret i1 %r
}

; Intentional negative test.
define i1 @addand_eq_i8_fail_abs_p2_minmax_not(i8 %x) nounwind {
; CHECK-LABEL: addand_eq_i8_fail_abs_p2_minmax_not:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpb $124, %dil
; CHECK-NEXT:    sete %cl
; CHECK-NEXT:    cmpb $-8, %dil
; CHECK-NEXT:    sete %al
; CHECK-NEXT:    orb %cl, %al
; CHECK-NEXT:    retq
  %cmp1 = icmp eq i8 %x, 124
  %cmp2 = icmp eq i8 %x, -8
  %r = or i1 %cmp1, %cmp2
  ret i1 %r
}

define i1 @addand_ne_i8(i8 %x) nounwind {
; CHECK-LABEL: addand_ne_i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addb $5, %dil
; CHECK-NEXT:    testb $-65, %dil
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %cmp1 = icmp ne i8 %x, 59
  %cmp2 = icmp ne i8 %x, -5
  %r = and i1 %cmp1, %cmp2
  ret i1 %r
}

; Intentional negative test.
define i1 @addand_eq_i64_fail_non_p2_dif(i64 %x) nounwind {
; CHECK-LABEL: addand_eq_i64_fail_non_p2_dif:
; CHECK:       # %bb.0:
; CHECK-NEXT:    cmpq $-8, %rdi
; CHECK-NEXT:    setne %cl
; CHECK-NEXT:    cmpq $-17, %rdi
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    andb %cl, %al
; CHECK-NEXT:    retq
  %cmp1 = icmp ne i64 %x, -8
  %cmp2 = icmp ne i64 %x, -17
  %r = and i1 %cmp1, %cmp2
  ret i1 %r
}

define i1 @addand_eq_i64(i64 %x) nounwind {
; CHECK-LABEL: addand_eq_i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    addq $256, %rdi # imm = 0x100
; CHECK-NEXT:    testq $-1025, %rdi # imm = 0xFBFF
; CHECK-NEXT:    setne %al
; CHECK-NEXT:    retq
  %cmp1 = icmp ne i64 %x, 768
  %cmp2 = icmp ne i64 %x, -256
  %r = and i1 %cmp1, %cmp2
  ret i1 %r
}
