; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple=xtensa -O1 -mattr=+windowed -verify-machineinstrs < %s \
; RUN:   | FileCheck %s -check-prefix=XTENSA

; Check placement of first 6 arguments in registers and 7th argument on stack
define dso_local i32 @test1(i32 noundef %a, i32 noundef %b, i32 noundef %c, i32 noundef %d, i32 noundef %e, i32 noundef %f, ptr nocapture noundef readonly byval(i32) align 4 %p) {
; XTENSA-LABEL: test1:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a8, a7, a2
; XTENSA-NEXT:    l32i a9, a1, 32
; XTENSA-NEXT:    add a2, a8, a9
; XTENSA-NEXT:    retw
  %l = load i32, ptr %p, align 4
  %sum = add nsw i32 %f, %a
  %1 = add nsw i32 %sum, %l
  ret i32 %1
}

; Check placement of second i64 argument in registers
define dso_local i32 @test2(i32 noundef %a, i64 noundef %b, i32 noundef %c) {
; XTENSA-LABEL: test2:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a8, a6, a2
; XTENSA-NEXT:    add a2, a8, a4
; XTENSA-NEXT:    retw
  %tr = trunc i64 %b to i32
  %sum = add nsw i32 %c, %a
  %1 = add nsw i32 %sum, %tr
  ret i32 %1
}

; Check placement of first argument typeof i8 in register
define dso_local i32 @test3(i8 noundef signext %a, i64 noundef %b, i32 noundef %c) {
; XTENSA-LABEL: test3:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a8, a2, a6
; XTENSA-NEXT:    add a2, a8, a4
; XTENSA-NEXT:    retw
  %tr = trunc i64 %b to i32
  %se = sext i8 %a to i32
  %sum = add nsw i32 %se, %c
  %1 = add nsw i32 %sum, %tr
  ret i32 %1
}

; Check placement of 4th argument typeof i64 on stack
define dso_local i32 @test4(i8 noundef signext %a, i64 noundef %b, i32 noundef %c, ptr nocapture noundef readonly byval(i64) align 8 %p) {
; XTENSA-LABEL: test4:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a8, a2, a6
; XTENSA-NEXT:    add a8, a8, a4
; XTENSA-NEXT:    l32i a9, a1, 32
; XTENSA-NEXT:    add a2, a8, a9
; XTENSA-NEXT:    retw
  %l = load i64, ptr %p, align 8
  %tr1 = trunc i64 %b to i32
  %tr2 = trunc i64 %l to i32
  %se = sext i8 %a to i32
  %sum1 = add nsw i32 %se, %c
  %sum2 = add nsw i32 %sum1, %tr1
  %1 = add nsw i32 %sum2, %tr2
  ret i32 %1
}

; Check placement of 128 bit structure on registers
define dso_local i32 @test5([4 x i32] %a, i32 noundef %b) {
; XTENSA-LABEL: test5:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a2, a2, a6
; XTENSA-NEXT:    retw
  %ev = extractvalue [4 x i32] %a, 0
  %1 = add nsw i32 %ev, %b
  ret i32 %1
}

; Check placement of 128 bit structure on stack
define dso_local i32 @test6(i32 noundef %a, [4 x i32] %b) {
; XTENSA-LABEL: test6:
; XTENSA:         .cfi_startproc
; XTENSA-NEXT:  # %bb.0:
; XTENSA-NEXT:    entry a1, 32
; XTENSA-NEXT:    .cfi_def_cfa_offset 32
; XTENSA-NEXT:    add a2, a3, a2
; XTENSA-NEXT:    retw
  %ev = extractvalue [4 x i32] %b, 0
  %1 = add nsw i32 %ev, %a
  ret i32 %1
}
