; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt < %s -S -passes=inline | FileCheck %s

define i32 @callee([2 x i32] %agg) {
; CHECK-LABEL: define i32 @callee(
; CHECK-SAME: [2 x i32] [[AGG:%.*]]) {
; CHECK-NEXT:    [[V:%.*]] = extractvalue [2 x i32] [[AGG]], 0
; CHECK-NEXT:    [[C:%.*]] = icmp eq i32 [[V]], 0
; CHECK-NEXT:    br i1 [[C]], label %[[IS_NULL:.*]], label %[[NON_NULL:.*]]
; CHECK:       [[IS_NULL]]:
; CHECK-NEXT:    ret i32 0
; CHECK:       [[NON_NULL]]:
; CHECK-NEXT:    [[R:%.*]] = call i32 @callee([2 x i32] [[AGG]])
; CHECK-NEXT:    ret i32 [[R]]
;
  %v = extractvalue [2 x i32] %agg, 0
  %c = icmp eq i32 %v, 0
  br i1 %c, label %is_null, label %non_null

is_null:
  ret i32 0

non_null:
  %r = call i32 @callee([2 x i32] %agg)
  ret i32 %r
}

define i32 @caller_simplified(i32 %arg) {
; CHECK-LABEL: define i32 @caller_simplified(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[AGG0:%.*]] = insertvalue [2 x i32] poison, i32 0, 0
; CHECK-NEXT:    [[AGG1:%.*]] = insertvalue [2 x i32] [[AGG0]], i32 [[ARG]], 1
; CHECK-NEXT:    ret i32 0
;
  %agg0 = insertvalue [2 x i32] poison, i32 0, 0
  %agg1 = insertvalue [2 x i32] %agg0, i32 %arg, 1
  %v = call i32 @callee([2 x i32] %agg1)
  ret i32 %v
}

define i32 @caller_not_simplified(i32 %arg) {
; CHECK-LABEL: define i32 @caller_not_simplified(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[AGG0:%.*]] = insertvalue [2 x i32] poison, i32 1, 0
; CHECK-NEXT:    [[AGG1:%.*]] = insertvalue [2 x i32] [[AGG0]], i32 [[ARG]], 1
; CHECK-NEXT:    [[V:%.*]] = call i32 @callee([2 x i32] [[AGG1]])
; CHECK-NEXT:    ret i32 [[V]]
;
  %agg0 = insertvalue [2 x i32] poison, i32 1, 0
  %agg1 = insertvalue [2 x i32] %agg0, i32 %arg, 1
  %v = call i32 @callee([2 x i32] %agg1)
  ret i32 %v
}

define i32 @caller_not_simplified2(i32 %arg) {
; CHECK-LABEL: define i32 @caller_not_simplified2(
; CHECK-SAME: i32 [[ARG:%.*]]) {
; CHECK-NEXT:    [[AGG0:%.*]] = insertvalue [2 x i32] poison, i32 0, 1
; CHECK-NEXT:    [[AGG1:%.*]] = insertvalue [2 x i32] [[AGG0]], i32 [[ARG]], 0
; CHECK-NEXT:    [[V:%.*]] = call i32 @callee([2 x i32] [[AGG1]])
; CHECK-NEXT:    ret i32 [[V]]
;
  %agg0 = insertvalue [2 x i32] poison, i32 0, 1
  %agg1 = insertvalue [2 x i32] %agg0, i32 %arg, 0
  %v = call i32 @callee([2 x i32] %agg1)
  ret i32 %v
}
