; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -S -passes=instcombine < %s | FileCheck %s

; The last test needs this weird datalayout.
target datalayout = "i32:8:8"
; Without it, InstCombine will align the pointed on 4 Bytes
; The KnownBitsZero that result from the alignment allows to
; turn:
;    and i32 %mul, 255
; to:
;    and i32 %mul, 252
; The mask is no longer in the form 2^n-1  and this prevents the transformation.

declare void @use.i64(i64)

; return mul(zext x, zext y) > MAX
define i32 @pr4917_1(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; return mul(zext x, zext y) >= MAX+1
define i32 @pr4917_1a(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_1a(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp uge i64 %mul64, 4294967296
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; mul(zext x, zext y) > MAX
; mul(x, y) is used
define i32 @pr4917_2(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[UMUL_VALUE:%.*]] = extractvalue { i32, i1 } [[UMUL]], 0
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = select i1 [[OVERFLOW]], i32 [[UMUL_VALUE]], i32 111
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %mul32 = trunc i64 %mul64 to i32
  %retval = select i1 %overflow, i32 %mul32, i32 111
  ret i32 %retval
}

; return mul(zext x, zext y) > MAX
; mul is used in non-truncate
define i64 @pr4917_3(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[R:%.*]] = zext i32 [[Y:%.*]] to i64
; CHECK-NEXT:    [[MUL64:%.*]] = mul nuw i64 [[L]], [[R]]
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i64 [[MUL64]], 4294967295
; CHECK-NEXT:    [[RETVAL:%.*]] = select i1 [[OVERFLOW]], i64 [[MUL64]], i64 111
; CHECK-NEXT:    ret i64 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %retval = select i1 %overflow, i64 %mul64, i64 111
  ret i64 %retval
}

; return mul(zext x, zext y) <= MAX
define i32 @pr4917_4(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[TMP0:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[OVERFLOW:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ule i64 %mul64, 4294967295
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; return mul(zext x, zext y) < MAX+1
define i32 @pr4917_4a(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4917_4a(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[TMP0:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[OVERFLOW:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ult i64 %mul64, 4294967296
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; operands of mul are of different size
define i32 @pr4917_5(i32 %x, i8 %y) nounwind {
; CHECK-LABEL: @pr4917_5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = zext i8 [[Y:%.*]] to i32
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[TMP0]])
; CHECK-NEXT:    [[UMUL_VALUE:%.*]] = extractvalue { i32, i1 } [[UMUL]], 0
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = select i1 [[OVERFLOW]], i32 [[UMUL_VALUE]], i32 111
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i8 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %mul32 = trunc i64 %mul64 to i32
  %retval = select i1 %overflow, i32 %mul32, i32 111
  ret i32 %retval
}

; mul(zext x, zext y) != zext trunc mul
define i32 @pr4918_1(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4918_1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %part32 = trunc i64 %mul64 to i32
  %part64 = zext i32 %part32 to i64
  %overflow = icmp ne i64 %mul64, %part64
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; mul(zext x, zext y) == zext trunc mul
define i32 @pr4918_2(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4918_2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[TMP0:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[OVERFLOW:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %part32 = trunc i64 %mul64 to i32
  %part64 = zext i32 %part32 to i64
  %overflow = icmp eq i64 %mul64, %part64
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

; zext trunc mul != mul(zext x, zext y)
define i32 @pr4918_3(i32 %x, i32 %y) nounwind {
; CHECK-LABEL: @pr4918_3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %part32 = trunc i64 %mul64 to i32
  %part64 = zext i32 %part32 to i64
  %overflow = icmp ne i64 %part64, %mul64
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

define <4 x i32> @pr20113(<4 x i16> %a, <4 x i16> %b) {
; CHECK-LABEL: @pr20113(
; CHECK-NEXT:    [[VMOVL_I_I726:%.*]] = zext <4 x i16> [[A:%.*]] to <4 x i32>
; CHECK-NEXT:    [[VMOVL_I_I712:%.*]] = zext <4 x i16> [[B:%.*]] to <4 x i32>
; CHECK-NEXT:    [[MUL_I703:%.*]] = mul nuw <4 x i32> [[VMOVL_I_I712]], [[VMOVL_I_I726]]
; CHECK-NEXT:    [[TMP:%.*]] = icmp sgt <4 x i32> [[MUL_I703]], splat (i32 -1)
; CHECK-NEXT:    [[VCGEZ_I:%.*]] = sext <4 x i1> [[TMP]] to <4 x i32>
; CHECK-NEXT:    ret <4 x i32> [[VCGEZ_I]]
;
  %vmovl.i.i726 = zext <4 x i16> %a to <4 x i32>
  %vmovl.i.i712 = zext <4 x i16> %b to <4 x i32>
  %mul.i703 = mul <4 x i32> %vmovl.i.i712, %vmovl.i.i726
  %tmp = icmp sge <4 x i32> %mul.i703, zeroinitializer
  %vcgez.i = sext <4 x i1> %tmp to <4 x i32>
  ret <4 x i32> %vcgez.i
}


@pr21445_data = external global i32
define i1 @pr21445(i8 %a) {
; CHECK-LABEL: @pr21445(
; CHECK-NEXT:    [[UMUL:%.*]] = call { i8, i1 } @llvm.umul.with.overflow.i8(i8 [[A:%.*]], i8 ptrtoint (ptr @pr21445_data to i8))
; CHECK-NEXT:    [[CMP:%.*]] = extractvalue { i8, i1 } [[UMUL]], 1
; CHECK-NEXT:    ret i1 [[CMP]]
;
  %ext = zext i8 %a to i32
  %ext2 = zext i8 ptrtoint (ptr @pr21445_data to i8) to i32
  %mul = mul i32 %ext, %ext2
  %and = and i32 %mul, 255
  %cmp = icmp ne i32 %mul, %and
  ret i1 %cmp
}

; Negative test: mul(zext x, zext y) may overflow.
define i32 @mul_may_overflow(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_may_overflow(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[L:%.*]] = zext i32 [[X:%.*]] to i34
; CHECK-NEXT:    [[R:%.*]] = zext i32 [[Y:%.*]] to i34
; CHECK-NEXT:    [[MUL34:%.*]] = mul i34 [[L]], [[R]]
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ult i34 [[MUL34]], 4294967296
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i34
  %r = zext i32 %y to i34
  %mul34 = mul i34 %l, %r
  %overflow = icmp ule i34 %mul34, 4294967295
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

define i32 @mul_known_nuw(i32 %x, i32 %y) {
; CHECK-LABEL: @mul_known_nuw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[TMP0:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    [[OVERFLOW:%.*]] = xor i1 [[TMP0]], true
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
entry:
  %l = zext i32 %x to i34
  %r = zext i32 %y to i34
  %mul34 = mul nuw i34 %l, %r
  %overflow = icmp ule i34 %mul34, 4294967295
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

define i32 @extra_and_use(i32 %x, i32 %y) {
; CHECK-LABEL: @extra_and_use(
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[UMUL_VALUE:%.*]] = extractvalue { i32, i1 } [[UMUL]], 0
; CHECK-NEXT:    [[AND:%.*]] = zext i32 [[UMUL_VALUE]] to i64
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    call void @use.i64(i64 [[AND]])
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %and = and i64 %mul64, u0xffffffff
  call void @use.i64(i64 %and)
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

define i32 @extra_and_use_small_mask(i32 %x, i32 %y) {
; CHECK-LABEL: @extra_and_use_small_mask(
; CHECK-NEXT:    [[UMUL:%.*]] = call { i32, i1 } @llvm.umul.with.overflow.i32(i32 [[X:%.*]], i32 [[Y:%.*]])
; CHECK-NEXT:    [[UMUL_VALUE:%.*]] = extractvalue { i32, i1 } [[UMUL]], 0
; CHECK-NEXT:    [[TMP1:%.*]] = and i32 [[UMUL_VALUE]], 268435455
; CHECK-NEXT:    [[AND:%.*]] = zext nneg i32 [[TMP1]] to i64
; CHECK-NEXT:    [[OVERFLOW:%.*]] = extractvalue { i32, i1 } [[UMUL]], 1
; CHECK-NEXT:    call void @use.i64(i64 [[AND]])
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %and = and i64 %mul64, u0xfffffff
  call void @use.i64(i64 %and)
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}

define i32 @extra_and_use_mask_too_large(i32 %x, i32 %y) {
; CHECK-LABEL: @extra_and_use_mask_too_large(
; CHECK-NEXT:    [[L:%.*]] = zext i32 [[X:%.*]] to i64
; CHECK-NEXT:    [[R:%.*]] = zext i32 [[Y:%.*]] to i64
; CHECK-NEXT:    [[MUL64:%.*]] = mul nuw i64 [[L]], [[R]]
; CHECK-NEXT:    [[OVERFLOW:%.*]] = icmp ugt i64 [[MUL64]], 4294967295
; CHECK-NEXT:    [[AND:%.*]] = and i64 [[MUL64]], 68719476735
; CHECK-NEXT:    call void @use.i64(i64 [[AND]])
; CHECK-NEXT:    [[RETVAL:%.*]] = zext i1 [[OVERFLOW]] to i32
; CHECK-NEXT:    ret i32 [[RETVAL]]
;
  %l = zext i32 %x to i64
  %r = zext i32 %y to i64
  %mul64 = mul i64 %l, %r
  %overflow = icmp ugt i64 %mul64, 4294967295
  %and = and i64 %mul64, u0xfffffffff
  call void @use.i64(i64 %and)
  %retval = zext i1 %overflow to i32
  ret i32 %retval
}
