# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p550 -iterations=1 < %s | FileCheck %s

fmin.s ft0, fa0, fa1
fmax.s ft1, fa0, fa1
fmadd.s fs0, fs0, fs8, fs9
fmsub.s fs1, fs1, fs8, fs9
fmul.s fs3, fs3, fs4
fadd.s fs4, fs4, fs5
fdiv.s fs2, fs3, fs4
fsqrt.s ft1, fa2

fcvt.s.w ft2, a0
fcvt.s.l ft3, a1
fcvt.s.wu ft2, a0
fcvt.s.lu ft3, a1
fcvt.w.s a0, ft2
fcvt.l.s a1, fs2
fcvt.wu.s a0, ft2
fcvt.lu.s a1, fs2

feq.s a2, fa0, fa1
fclass.s a3, fa2

fmin.d ft2, ft4, ft5
fmax.d ft3, ft4, ft5
fmadd.d fs0, fs0, fs8, fs9
fmsub.d fs1, fs1, fs8, fs9
fmul.d ft4, ft4, ft5
fadd.d ft4, ft5, ft6
fdiv.d fs4, fa3, ft5
fsqrt.d ft2, fa3

fcvt.d.w ft2, a0
fcvt.d.l ft3, a1
fcvt.d.w ft2, a0
fcvt.d.l ft3, a1
fcvt.w.d a0, ft2
fcvt.l.d a1, fs2

feq.d a2, fa0, fa1
fclass.d a3, fa2

fcvt.d.s ft1, ft2
fcvt.s.d ft3, ft4

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      36
# CHECK-NEXT: Total Cycles:      106
# CHECK-NEXT: Total uOps:        36

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.34
# CHECK-NEXT: IPC:               0.34
# CHECK-NEXT: Block RThroughput: 99.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      2     0.50                        fmin.s	ft0, fa0, fa1
# CHECK-NEXT:  1      2     0.50                        fmax.s	ft1, fa0, fa1
# CHECK-NEXT:  1      4     0.50                        fmadd.s	fs0, fs0, fs8, fs9
# CHECK-NEXT:  1      4     0.50                        fmsub.s	fs1, fs1, fs8, fs9
# CHECK-NEXT:  1      4     0.50                        fmul.s	fs3, fs3, fs4
# CHECK-NEXT:  1      4     0.50                        fadd.s	fs4, fs4, fs5
# CHECK-NEXT:  1      19    18.00                       fdiv.s	fs2, fs3, fs4
# CHECK-NEXT:  1      18    17.00                       fsqrt.s	ft1, fa2
# CHECK-NEXT:  1      2     1.00                        fcvt.s.w	ft2, a0
# CHECK-NEXT:  1      2     1.00                        fcvt.s.l	ft3, a1
# CHECK-NEXT:  1      2     1.00                        fcvt.s.wu	ft2, a0
# CHECK-NEXT:  1      2     1.00                        fcvt.s.lu	ft3, a1
# CHECK-NEXT:  1      2     1.00                        fcvt.w.s	a0, ft2
# CHECK-NEXT:  1      2     1.00                        fcvt.l.s	a1, fs2
# CHECK-NEXT:  1      2     1.00                        fcvt.wu.s	a0, ft2
# CHECK-NEXT:  1      2     1.00                        fcvt.lu.s	a1, fs2
# CHECK-NEXT:  1      2     1.00                        feq.s	a2, fa0, fa1
# CHECK-NEXT:  1      2     1.00                        fclass.s	a3, fa2
# CHECK-NEXT:  1      2     0.50                        fmin.d	ft2, ft4, ft5
# CHECK-NEXT:  1      2     0.50                        fmax.d	ft3, ft4, ft5
# CHECK-NEXT:  1      4     0.50                        fmadd.d	fs0, fs0, fs8, fs9
# CHECK-NEXT:  1      4     0.50                        fmsub.d	fs1, fs1, fs8, fs9
# CHECK-NEXT:  1      4     0.50                        fmul.d	ft4, ft4, ft5
# CHECK-NEXT:  1      4     0.50                        fadd.d	ft4, ft5, ft6
# CHECK-NEXT:  1      33    32.00                       fdiv.d	fs4, fa3, ft5
# CHECK-NEXT:  1      33    32.00                       fsqrt.d	ft2, fa3
# CHECK-NEXT:  1      2     1.00                        fcvt.d.w	ft2, a0
# CHECK-NEXT:  1      2     1.00                        fcvt.d.l	ft3, a1
# CHECK-NEXT:  1      2     1.00                        fcvt.d.w	ft2, a0
# CHECK-NEXT:  1      2     1.00                        fcvt.d.l	ft3, a1
# CHECK-NEXT:  1      2     1.00                        fcvt.w.d	a0, ft2
# CHECK-NEXT:  1      2     1.00                        fcvt.l.d	a1, fs2
# CHECK-NEXT:  1      2     1.00                        feq.d	a2, fa0, fa1
# CHECK-NEXT:  1      2     1.00                        fclass.d	a3, fa2
# CHECK-NEXT:  1      2     0.50                        fcvt.d.s	ft1, ft2
# CHECK-NEXT:  1      2     0.50                        fcvt.s.d	ft3, ft4

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP500Div
# CHECK-NEXT: [1]   - SiFiveP500FEXQ0
# CHECK-NEXT: [2]   - SiFiveP500FEXQ1
# CHECK-NEXT: [3]   - SiFiveP500FloatDiv
# CHECK-NEXT: [4]   - SiFiveP500IEXQ0
# CHECK-NEXT: [5]   - SiFiveP500IEXQ1
# CHECK-NEXT: [6]   - SiFiveP500IEXQ2
# CHECK-NEXT: [7]   - SiFiveP500Load
# CHECK-NEXT: [8]   - SiFiveP500Store

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]
# CHECK-NEXT:  -     14.00  14.00  99.00   -      -     8.00    -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    Instructions:
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmin.s	ft0, fa0, fa1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fmax.s	ft1, fa0, fa1
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmadd.s	fs0, fs0, fs8, fs9
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fmsub.s	fs1, fs1, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmul.s	fs3, fs3, fs4
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fadd.s	fs4, fs4, fs5
# CHECK-NEXT:  -      -     1.00   18.00   -      -      -      -      -     fdiv.s	fs2, fs3, fs4
# CHECK-NEXT:  -      -     1.00   17.00   -      -      -      -      -     fsqrt.s	ft1, fa2
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.s.w	ft2, a0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.s.l	ft3, a1
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.s.wu	ft2, a0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.s.lu	ft3, a1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.w.s	a0, ft2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.l.s	a1, fs2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.wu.s	a0, ft2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.lu.s	a1, fs2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     feq.s	a2, fa0, fa1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fclass.s	a3, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmin.d	ft2, ft4, ft5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmax.d	ft3, ft4, ft5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmadd.d	fs0, fs0, fs8, fs9
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fmsub.d	fs1, fs1, fs8, fs9
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fmul.d	ft4, ft4, ft5
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fadd.d	ft4, ft5, ft6
# CHECK-NEXT:  -      -     1.00   32.00   -      -      -      -      -     fdiv.d	fs4, fa3, ft5
# CHECK-NEXT:  -      -     1.00   32.00   -      -      -      -      -     fsqrt.d	ft2, fa3
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.d.w	ft2, a0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.d.l	ft3, a1
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.d.w	ft2, a0
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -      -     fcvt.d.l	ft3, a1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.w.d	a0, ft2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fcvt.l.d	a1, fs2
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     feq.d	a2, fa0, fa1
# CHECK-NEXT:  -     1.00    -      -      -      -      -      -      -     fclass.d	a3, fa2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fcvt.d.s	ft1, ft2
# CHECK-NEXT:  -      -     1.00    -      -      -      -      -      -     fcvt.s.d	ft3, ft4
