// NOTE: Assertions have been autogenerated by utils/update_mc_test_checks.py UTC_ARGS: --unique --sort --version 5
// RUN: llvm-mc -triple=amdgcn -mcpu=gfx1100 -mattr=-real-true16,+wavefrontsize64 -show-encoding %s 2>&1 | FileCheck --check-prefix=GFX11 %s

v_cmpx_class_f16 v1, v255
// GFX11: v_cmpx_class_f16_e64 v1, v255           ; encoding: [0x7e,0x00,0xfd,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_class_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_class_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xfd,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_class_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_class_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xfd,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_class_f16 v255, v2
// GFX11: v_cmpx_class_f16_e64 v255, v2           ; encoding: [0x7e,0x00,0xfd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_class_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_class_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xfd,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_class_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_class_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xfd,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_eq_f16 v1, v255
// GFX11: v_cmpx_eq_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x82,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x82,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_eq_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x82,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_f16 v255, v2
// GFX11: v_cmpx_eq_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x82,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x82,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_eq_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x82,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_eq_i16 v1, v255
// GFX11: v_cmpx_eq_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb2,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb2,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_eq_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb2,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_i16 v255, v2
// GFX11: v_cmpx_eq_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb2,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb2,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_eq_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb2,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_eq_u16 v1, v255
// GFX11: v_cmpx_eq_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xba,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_eq_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xba,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_eq_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xba,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_eq_u16 v255, v2
// GFX11: v_cmpx_eq_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xba,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_eq_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_eq_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xba,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_eq_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_eq_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xba,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ge_f16 v1, v255
// GFX11: v_cmpx_ge_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x86,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x86,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ge_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x86,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_f16 v255, v2
// GFX11: v_cmpx_ge_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x86,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x86,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ge_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x86,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ge_i16 v1, v255
// GFX11: v_cmpx_ge_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb6,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb6,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ge_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb6,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_i16 v255, v2
// GFX11: v_cmpx_ge_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb6,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb6,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ge_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb6,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ge_u16 v1, v255
// GFX11: v_cmpx_ge_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xbe,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ge_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbe,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ge_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbe,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ge_u16 v255, v2
// GFX11: v_cmpx_ge_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xbe,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ge_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ge_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbe,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ge_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ge_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbe,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_gt_f16 v1, v255
// GFX11: v_cmpx_gt_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x84,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x84,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_gt_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x84,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_f16 v255, v2
// GFX11: v_cmpx_gt_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x84,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x84,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_gt_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x84,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_gt_i16 v1, v255
// GFX11: v_cmpx_gt_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb4,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb4,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_gt_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb4,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_i16 v255, v2
// GFX11: v_cmpx_gt_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb4,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb4,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_gt_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb4,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_gt_u16 v1, v255
// GFX11: v_cmpx_gt_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xbc,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_gt_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbc,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_gt_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbc,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_gt_u16 v255, v2
// GFX11: v_cmpx_gt_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xbc,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_gt_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_gt_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbc,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_gt_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_gt_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbc,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_le_f16 v1, v255
// GFX11: v_cmpx_le_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x83,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x83,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_le_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x83,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_f16 v255, v2
// GFX11: v_cmpx_le_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x83,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x83,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_le_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x83,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_le_i16 v1, v255
// GFX11: v_cmpx_le_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb3,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb3,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_le_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb3,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_i16 v255, v2
// GFX11: v_cmpx_le_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb3,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb3,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_le_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb3,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_le_u16 v1, v255
// GFX11: v_cmpx_le_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xbb,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_le_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbb,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_le_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbb,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_le_u16 v255, v2
// GFX11: v_cmpx_le_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xbb,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_le_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_le_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbb,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_le_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_le_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbb,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_lg_f16 v1, v255
// GFX11: v_cmpx_lg_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x85,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lg_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lg_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x85,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_lg_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lg_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x85,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lg_f16 v255, v2
// GFX11: v_cmpx_lg_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x85,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lg_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lg_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x85,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_lg_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lg_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x85,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_lt_f16 v1, v255
// GFX11: v_cmpx_lt_f16_e64 v1, v255              ; encoding: [0x7e,0x00,0x81,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x81,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_lt_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x81,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_f16 v255, v2
// GFX11: v_cmpx_lt_f16_e64 v255, v2              ; encoding: [0x7e,0x00,0x81,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x81,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_lt_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x81,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_lt_i16 v1, v255
// GFX11: v_cmpx_lt_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb1,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb1,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_lt_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb1,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_i16 v255, v2
// GFX11: v_cmpx_lt_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb1,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb1,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_lt_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb1,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_lt_u16 v1, v255
// GFX11: v_cmpx_lt_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb9,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_lt_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb9,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_lt_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb9,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_lt_u16 v255, v2
// GFX11: v_cmpx_lt_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb9,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_lt_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_lt_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb9,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_lt_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_lt_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb9,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ne_i16 v1, v255
// GFX11: v_cmpx_ne_i16_e64 v1, v255              ; encoding: [0x7e,0x00,0xb5,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_i16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ne_i16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb5,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ne_i16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ne_i16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb5,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_i16 v255, v2
// GFX11: v_cmpx_ne_i16_e64 v255, v2              ; encoding: [0x7e,0x00,0xb5,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_i16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ne_i16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xb5,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ne_i16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ne_i16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xb5,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ne_u16 v1, v255
// GFX11: v_cmpx_ne_u16_e64 v1, v255              ; encoding: [0x7e,0x00,0xbd,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ne_u16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ne_u16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbd,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ne_u16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ne_u16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbd,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ne_u16 v255, v2
// GFX11: v_cmpx_ne_u16_e64 v255, v2              ; encoding: [0x7e,0x00,0xbd,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ne_u16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ne_u16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0xbd,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ne_u16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ne_u16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0xbd,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_neq_f16 v1, v255
// GFX11: v_cmpx_neq_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x8d,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_neq_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_neq_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8d,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_neq_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_neq_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8d,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_neq_f16 v255, v2
// GFX11: v_cmpx_neq_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x8d,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_neq_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_neq_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8d,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_neq_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_neq_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8d,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_nge_f16 v1, v255
// GFX11: v_cmpx_nge_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x89,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nge_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nge_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x89,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_nge_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nge_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x89,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nge_f16 v255, v2
// GFX11: v_cmpx_nge_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x89,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nge_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nge_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x89,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_nge_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nge_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x89,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_ngt_f16 v1, v255
// GFX11: v_cmpx_ngt_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x8b,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_ngt_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ngt_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8b,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_ngt_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ngt_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8b,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_ngt_f16 v255, v2
// GFX11: v_cmpx_ngt_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x8b,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_ngt_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_ngt_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8b,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_ngt_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_ngt_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8b,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_nle_f16 v1, v255
// GFX11: v_cmpx_nle_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x8c,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nle_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nle_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8c,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_nle_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nle_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8c,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nle_f16 v255, v2
// GFX11: v_cmpx_nle_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x8c,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nle_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nle_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8c,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_nle_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nle_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8c,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_nlg_f16 v1, v255
// GFX11: v_cmpx_nlg_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x8a,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlg_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nlg_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8a,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_nlg_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nlg_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8a,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlg_f16 v255, v2
// GFX11: v_cmpx_nlg_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x8a,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlg_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nlg_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8a,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_nlg_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nlg_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8a,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_nlt_f16 v1, v255
// GFX11: v_cmpx_nlt_f16_e64 v1, v255             ; encoding: [0x7e,0x00,0x8e,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_nlt_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nlt_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8e,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_nlt_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nlt_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8e,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_nlt_f16 v255, v2
// GFX11: v_cmpx_nlt_f16_e64 v255, v2             ; encoding: [0x7e,0x00,0x8e,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_nlt_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_nlt_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x8e,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_nlt_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_nlt_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x8e,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_o_f16 v1, v255
// GFX11: v_cmpx_o_f16_e64 v1, v255               ; encoding: [0x7e,0x00,0x87,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_o_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_o_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x87,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_o_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_o_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x87,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_o_f16 v255, v2
// GFX11: v_cmpx_o_f16_e64 v255, v2               ; encoding: [0x7e,0x00,0x87,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_o_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_o_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x87,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_o_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_o_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x87,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]

v_cmpx_u_f16 v1, v255
// GFX11: v_cmpx_u_f16_e64 v1, v255               ; encoding: [0x7e,0x00,0x88,0xd4,0x01,0xff,0x03,0x00]

v_cmpx_u_f16 v1, v255 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_u_f16_e64_dpp v1, v255 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x88,0xd4,0xe9,0xfe,0x03,0x00,0x01,0x77,0x39,0x05]

v_cmpx_u_f16 v1, v255 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_u_f16_e64_dpp v1, v255 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x88,0xd4,0xfa,0xfe,0x03,0x00,0x01,0x1b,0x00,0xff]

v_cmpx_u_f16 v255, v2
// GFX11: v_cmpx_u_f16_e64 v255, v2               ; encoding: [0x7e,0x00,0x88,0xd4,0xff,0x05,0x02,0x00]

v_cmpx_u_f16 v255, v2 dpp8:[7,6,5,4,3,2,1,0]
// GFX11: v_cmpx_u_f16_e64_dpp v255, v2 dpp8:[7,6,5,4,3,2,1,0] ; encoding: [0x7e,0x00,0x88,0xd4,0xe9,0x04,0x02,0x00,0xff,0x77,0x39,0x05]

v_cmpx_u_f16 v255, v2 quad_perm:[3,2,1,0]
// GFX11: v_cmpx_u_f16_e64_dpp v255, v2 quad_perm:[3,2,1,0] row_mask:0xf bank_mask:0xf ; encoding: [0x7e,0x00,0x88,0xd4,0xfa,0x04,0x02,0x00,0xff,0x1b,0x00,0xff]
