; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc -mtriple arm64-apple-ios -mattr +cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-CMPBR
; RUN: llc -mtriple arm64-apple-ios -mattr -cmpbr -verify-machineinstrs -o - < %s | FileCheck %s --check-prefix=CHECK-NO-CMPBR


define void @cbgt_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbgt_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w0, w1, LBB0_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbgt_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.gt LBB0_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB0_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbge_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbge w0, w1, LBB1_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.ge LBB1_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB1_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}


define void @cbhi_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbhi_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi w0, w1, LBB2_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhi_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.hi LBB2_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB2_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhs_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbhs_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhs w0, w1, LBB3_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhs_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.hs LBB3_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB3_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbeq_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbeq_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbeq w0, w1, LBB4_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbeq_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.eq LBB4_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB4_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbne_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbne_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne w0, w1, LBB5_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbne_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.ne LBB5_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB5_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cble_ge_swap_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cble_ge_swap_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbge w1, w0, LBB6_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cble_ge_swap_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.le LBB6_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB6_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblo_hi_swap_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cblo_hi_swap_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi w1, w0, LBB7_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblo_hi_swap_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.lo LBB7_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB7_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbls_hs_swap_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cbls_hs_swap_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhs w1, w0, LBB8_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbls_hs_swap_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.ls LBB8_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB8_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblt_gt_swap_i32(i32 %a, i32 %b)  {
; CHECK-CMPBR-LABEL: cblt_gt_swap_i32:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt w1, w0, LBB9_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblt_gt_swap_i32:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp w0, w1
; CHECK-NO-CMPBR-NEXT:    b.lt LBB9_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB9_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i32 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbgt_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbgt_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt x0, x1, LBB10_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbgt_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.gt LBB10_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB10_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sgt i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbge_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbge_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbge x0, x1, LBB11_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbge_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.ge LBB11_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB11_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sge i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}


define void @cbhi_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbhi_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi x0, x1, LBB12_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhi_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.hi LBB12_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB12_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ugt i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbhs_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbhs_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhs x0, x1, LBB13_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbhs_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.hs LBB13_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB13_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp uge i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbeq_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbeq_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbeq x0, x1, LBB14_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbeq_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.eq LBB14_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB14_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp eq i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbne_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbne_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbne x0, x1, LBB15_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbne_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.ne LBB15_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB15_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ne i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cble_ge_swap_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cble_ge_swap_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbge x1, x0, LBB16_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cble_ge_swap_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.le LBB16_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB16_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp sle i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblo_hi_swap_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cblo_hi_swap_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhi x1, x0, LBB17_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblo_hi_swap_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.lo LBB17_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB17_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ult i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cbls_hs_swap_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cbls_hs_swap_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbhs x1, x0, LBB18_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cbls_hs_swap_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.ls LBB18_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB18_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp ule i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}

define void @cblt_gt_swap_i64(i64 %a, i64 %b)  {
; CHECK-CMPBR-LABEL: cblt_gt_swap_i64:
; CHECK-CMPBR:       ; %bb.0: ; %entry
; CHECK-CMPBR-NEXT:    cbgt x1, x0, LBB19_2
; CHECK-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-CMPBR-NEXT:    ret
; CHECK-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-CMPBR-NEXT:    brk #0x1
;
; CHECK-NO-CMPBR-LABEL: cblt_gt_swap_i64:
; CHECK-NO-CMPBR:       ; %bb.0: ; %entry
; CHECK-NO-CMPBR-NEXT:    cmp x0, x1
; CHECK-NO-CMPBR-NEXT:    b.lt LBB19_2
; CHECK-NO-CMPBR-NEXT:  ; %bb.1: ; %if.end
; CHECK-NO-CMPBR-NEXT:    ret
; CHECK-NO-CMPBR-NEXT:  LBB19_2: ; %if.then
; CHECK-NO-CMPBR-NEXT:    brk #0x1
entry:
  %cmp = icmp slt i64 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void @llvm.trap()
  unreachable

if.end:
  ret void
}
