; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32ZVFBFMIN,RV32-NO-ZFBFMIN
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64ZVFBFMIN,RV64-NO-ZFBFMIN
; RUN: llc -mtriple=riscv32 -target-abi=ilp32d -mattr=+v,+zfbfmin,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV32,RV32ZVFBFMIN,RV32-ZFBFMIN
; RUN: llc -mtriple=riscv64 -target-abi=lp64d -mattr=+v,+zfbfmin,+zvfbfmin,+f,+d -verify-machineinstrs < %s | FileCheck %s --check-prefixes=CHECK,RV64,RV64ZVFBFMIN,RV64-ZFBFMIN

define <4 x bfloat> @splat_idx_v4bf16(<4 x bfloat> %v, i64 %idx) {
; RV32-NO-ZFBFMIN-LABEL: splat_idx_v4bf16:
; RV32-NO-ZFBFMIN:       # %bb.0:
; RV32-NO-ZFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-NO-ZFBFMIN-NEXT:    vrgather.vx v9, v8, a0
; RV32-NO-ZFBFMIN-NEXT:    vmv1r.v v8, v9
; RV32-NO-ZFBFMIN-NEXT:    ret
;
; RV64-NO-ZFBFMIN-LABEL: splat_idx_v4bf16:
; RV64-NO-ZFBFMIN:       # %bb.0:
; RV64-NO-ZFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-NO-ZFBFMIN-NEXT:    vrgather.vx v9, v8, a0
; RV64-NO-ZFBFMIN-NEXT:    vmv1r.v v8, v9
; RV64-NO-ZFBFMIN-NEXT:    ret
;
; RV32-ZFBFMIN-LABEL: splat_idx_v4bf16:
; RV32-ZFBFMIN:       # %bb.0:
; RV32-ZFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV32-ZFBFMIN-NEXT:    vslidedown.vx v8, v8, a0
; RV32-ZFBFMIN-NEXT:    vmv.x.s a0, v8
; RV32-ZFBFMIN-NEXT:    vmv.v.x v8, a0
; RV32-ZFBFMIN-NEXT:    ret
;
; RV64-ZFBFMIN-LABEL: splat_idx_v4bf16:
; RV64-ZFBFMIN:       # %bb.0:
; RV64-ZFBFMIN-NEXT:    vsetivli zero, 4, e16, mf2, ta, ma
; RV64-ZFBFMIN-NEXT:    vslidedown.vx v8, v8, a0
; RV64-ZFBFMIN-NEXT:    vmv.x.s a0, v8
; RV64-ZFBFMIN-NEXT:    vmv.v.x v8, a0
; RV64-ZFBFMIN-NEXT:    ret
  %x = extractelement <4 x bfloat> %v, i64 %idx
  %ins = insertelement <4 x bfloat> poison, bfloat %x, i32 0
  %splat = shufflevector <4 x bfloat> %ins, <4 x bfloat> poison, <4 x i32> zeroinitializer
  ret <4 x bfloat> %splat
}

define <2 x bfloat> @buildvec_v2bf16(bfloat %a, bfloat %b) {
; RV32-NO-ZFBFMIN-LABEL: buildvec_v2bf16:
; RV32-NO-ZFBFMIN:       # %bb.0:
; RV32-NO-ZFBFMIN-NEXT:    fmv.x.w a0, fa1
; RV32-NO-ZFBFMIN-NEXT:    fmv.x.w a1, fa0
; RV32-NO-ZFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-NO-ZFBFMIN-NEXT:    vmv.v.x v8, a1
; RV32-NO-ZFBFMIN-NEXT:    vslide1down.vx v8, v8, a0
; RV32-NO-ZFBFMIN-NEXT:    ret
;
; RV64-NO-ZFBFMIN-LABEL: buildvec_v2bf16:
; RV64-NO-ZFBFMIN:       # %bb.0:
; RV64-NO-ZFBFMIN-NEXT:    fmv.x.w a0, fa1
; RV64-NO-ZFBFMIN-NEXT:    fmv.x.w a1, fa0
; RV64-NO-ZFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-NO-ZFBFMIN-NEXT:    vmv.v.x v8, a1
; RV64-NO-ZFBFMIN-NEXT:    vslide1down.vx v8, v8, a0
; RV64-NO-ZFBFMIN-NEXT:    ret
;
; RV32-ZFBFMIN-LABEL: buildvec_v2bf16:
; RV32-ZFBFMIN:       # %bb.0:
; RV32-ZFBFMIN-NEXT:    fmv.x.h a0, fa1
; RV32-ZFBFMIN-NEXT:    fmv.x.h a1, fa0
; RV32-ZFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV32-ZFBFMIN-NEXT:    vmv.v.x v8, a1
; RV32-ZFBFMIN-NEXT:    vslide1down.vx v8, v8, a0
; RV32-ZFBFMIN-NEXT:    ret
;
; RV64-ZFBFMIN-LABEL: buildvec_v2bf16:
; RV64-ZFBFMIN:       # %bb.0:
; RV64-ZFBFMIN-NEXT:    fmv.x.h a0, fa1
; RV64-ZFBFMIN-NEXT:    fmv.x.h a1, fa0
; RV64-ZFBFMIN-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; RV64-ZFBFMIN-NEXT:    vmv.v.x v8, a1
; RV64-ZFBFMIN-NEXT:    vslide1down.vx v8, v8, a0
; RV64-ZFBFMIN-NEXT:    ret
  %v1 = insertelement <2 x bfloat> poison, bfloat %a, i64 0
  %v2 = insertelement <2 x bfloat> %v1, bfloat %b, i64 1
  ret <2 x bfloat> %v2
}

define <2 x bfloat> @vid_v2bf16() {
; CHECK-LABEL: vid_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lui a0, 260096
; CHECK-NEXT:    vsetivli zero, 2, e32, m1, ta, ma
; CHECK-NEXT:    vmv.s.x v8, a0
; CHECK-NEXT:    ret
  ret <2 x bfloat> <bfloat 0.0, bfloat 1.0>
}

define <2 x bfloat> @vid_addend1_v2bf16() {
; CHECK-LABEL: vid_addend1_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    lui a0, 4
; CHECK-NEXT:    vsll.vi v8, v8, 7
; CHECK-NEXT:    addi a0, a0, -128
; CHECK-NEXT:    vadd.vx v8, v8, a0
; CHECK-NEXT:    ret
  ret <2 x bfloat> <bfloat 1.0, bfloat 2.0>
}

define <2 x bfloat> @vid_denominator2_v2bf16() {
; CHECK-LABEL: vid_denominator2_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    lui a0, 4
; CHECK-NEXT:    vsll.vi v8, v8, 7
; CHECK-NEXT:    addi a0, a0, -256
; CHECK-NEXT:    vadd.vx v8, v8, a0
; CHECK-NEXT:    ret
  ret <2 x bfloat> <bfloat 0.5, bfloat 1.0>
}

define <2 x bfloat> @vid_step2_v2bf16() {
; CHECK-LABEL: vid_step2_v2bf16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetivli zero, 2, e16, mf4, ta, ma
; CHECK-NEXT:    vid.v v8
; CHECK-NEXT:    vsll.vi v8, v8, 14
; CHECK-NEXT:    ret
  ret <2 x bfloat> <bfloat 0.0, bfloat 2.0>
}
;; NOTE: These prefixes are unused and the list is autogenerated. Do not add tests below this line:
; RV32: {{.*}}
; RV32ZVFBFMIN: {{.*}}
; RV64: {{.*}}
; RV64ZVFBFMIN: {{.*}}
