; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve,+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LV
; RUN: llc -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LV,CHECKFP
; RUN: llc -early-live-intervals -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve,+fullfp16 -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LIS
; RUN: llc -early-live-intervals -mtriple=thumbv8.1m.main-none-none-eabi -mattr=+mve.fp -verify-machineinstrs %s -o - | FileCheck %s --check-prefixes=CHECK,CHECK-LIS,CHECKFP

define arm_aapcs_vfpcc <4 x i32> @shuffle1_i32(<4 x i32> %src) {
; CHECK-LABEL: shuffle1_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s3
; CHECK-NEXT:    vmov.f32 s5, s2
; CHECK-NEXT:    vmov.f32 s6, s1
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @shuffle2_i32(<4 x i32> %src) {
; CHECK-LABEL: shuffle2_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @shuffle3_i32(<4 x i32> %src) {
; CHECK-LABEL: shuffle3_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s3
; CHECK-NEXT:    vmov.f32 s5, s1
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 3, i32 1, i32 2, i32 0>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @shuffle5_i32(<4 x i32> %src) {
; CHECK-LABEL: shuffle5_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.32 q1, q0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @shuffle6_i32(<4 x i32> %src) {
; CHECK-LABEL: shuffle6_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src, <4 x i32> undef, <4 x i32> <i32 undef, i32 undef, i32 undef, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @oneoff11_i32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: oneoff11_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s2, s1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src1, <4 x i32> %src2, <4 x i32> <i32 0, i32 1, i32 1, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @oneoff12_i32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: oneoff12_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s4
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src1, <4 x i32> %src2, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @oneoff21_i32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: oneoff21_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src1, <4 x i32> %src2, <4 x i32> <i32 4, i32 5, i32 6, i32 0>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @oneoff22_i32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: oneoff22_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmov.f32 s2, s0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src1, <4 x i32> %src2, <4 x i32> <i32 4, i32 5, i32 4, i32 7>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @oneoffundef_i32(<4 x i32> %src1, <4 x i32> %src2) {
; CHECK-LABEL: oneoffundef_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x i32> %src1, <4 x i32> %src2, <4 x i32> <i32 0, i32 4, i32 undef, i32 3>
  ret <4 x i32> %out
}

define arm_aapcs_vfpcc <4 x i32> @shuffle2step_i32(<8 x i32> %src) {
; CHECK-LABEL: shuffle2step_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s1
; CHECK-NEXT:    vmov.f32 s9, s3
; CHECK-NEXT:    vmov.f32 s1, s2
; CHECK-NEXT:    vmov.f32 s10, s5
; CHECK-NEXT:    vmov.f32 s11, s7
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmov.f32 s3, s6
; CHECK-NEXT:    vadd.i32 q0, q0, q2
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <8 x i32> %src, <8 x i32> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x i32> %src, <8 x i32> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %r = add <4 x i32> %s1, %s2
  ret <4 x i32> %r
}

define arm_aapcs_vfpcc <4 x i32> @shuffle3step_i32(<16 x i32> %src) {
; CHECK-LABEL: shuffle3step_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vmov.f32 s13, s4
; CHECK-NEXT:    vmov.f32 s14, s7
; CHECK-NEXT:    vmov.f32 s18, s6
; CHECK-NEXT:    vmov.f32 s12, s1
; CHECK-NEXT:    vmov.f32 s15, s10
; CHECK-NEXT:    vmov.f32 s16, s0
; CHECK-NEXT:    vmov.f32 s17, s3
; CHECK-NEXT:    vmov.f32 s19, s9
; CHECK-NEXT:    vadd.i32 q3, q4, q3
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s6, s8
; CHECK-NEXT:    vmov.f32 s7, s11
; CHECK-NEXT:    vadd.i32 q0, q3, q1
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  %s2 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 1, i32 4, i32 7, i32 10>
  %s3 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 2, i32 5, i32 8, i32 11>
  %a = add <4 x i32> %s1, %s2
  %r = add <4 x i32> %a, %s3
  ret <4 x i32> %r
}

define arm_aapcs_vfpcc <4 x i32> @shuffle4step_i32(<16 x i32> %src) {
; CHECK-LABEL: shuffle4step_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vmov.f32 s16, s3
; CHECK-NEXT:    vmov.f32 s20, s2
; CHECK-NEXT:    vmov.f32 s17, s7
; CHECK-NEXT:    vmov.f32 s18, s11
; CHECK-NEXT:    vmov.f32 s19, s15
; CHECK-NEXT:    vmov.f32 s21, s6
; CHECK-NEXT:    vmov.f32 s22, s10
; CHECK-NEXT:    vmov.f32 s23, s14
; CHECK-NEXT:    vadd.i32 q4, q5, q4
; CHECK-NEXT:    vmov.f32 s20, s1
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vmov.f32 s22, s9
; CHECK-NEXT:    vmov.f32 s23, s13
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s3, s12
; CHECK-NEXT:    vadd.i32 q0, q0, q5
; CHECK-NEXT:    vadd.i32 q0, q0, q4
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x i32> %src, <16 x i32> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = add <4 x i32> %s1, %s2
  %a2 = add <4 x i32> %s3, %s4
  %r = add <4 x i32> %a1, %a2
  ret <4 x i32> %r
}

; i16

define arm_aapcs_vfpcc <8 x i16> @shuffle1_i16(<8 x i16> %src) {
; CHECK-LABEL: shuffle1_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.16 q1, q0
; CHECK-NEXT:    vmov.f32 s0, s6
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @shuffle2_i16(<8 x i16> %src) {
; CHECK-LABEL: shuffle2_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @shuffle3_i16(<8 x i16> %src) {
; CHECK-LV-LABEL: shuffle3_i16:
; CHECK-LV:       @ %bb.0: @ %entry
; CHECK-LV-NEXT:    vmovx.f16 s5, s3
; CHECK-LV-NEXT:    vmovx.f16 s6, s1
; CHECK-LV-NEXT:    vmovx.f16 s4, s0
; CHECK-LV-NEXT:    vins.f16 s1, s0
; CHECK-LV-NEXT:    vins.f16 s6, s4
; CHECK-LV-NEXT:    vins.f16 s5, s3
; CHECK-LV-NEXT:    vmov.f32 s4, s2
; CHECK-LV-NEXT:    vmov.f32 s7, s1
; CHECK-LV-NEXT:    vmov q0, q1
; CHECK-LV-NEXT:    bx lr
;
; CHECK-LIS-LABEL: shuffle3_i16:
; CHECK-LIS:       @ %bb.0: @ %entry
; CHECK-LIS-NEXT:    vmov q1, q0
; CHECK-LIS-NEXT:    vmovx.f16 s2, s5
; CHECK-LIS-NEXT:    vmovx.f16 s0, s4
; CHECK-LIS-NEXT:    vins.f16 s5, s4
; CHECK-LIS-NEXT:    vins.f16 s2, s0
; CHECK-LIS-NEXT:    vmov.f32 s0, s6
; CHECK-LIS-NEXT:    vmovx.f16 s1, s7
; CHECK-LIS-NEXT:    vmov.f32 s3, s5
; CHECK-LIS-NEXT:    vins.f16 s1, s7
; CHECK-LIS-NEXT:    bx lr

entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 4, i32 5, i32 7, i32 6, i32 3, i32 1, i32 2, i32 0>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @shuffle5_i16(<8 x i16> %src) {
; CHECK-LABEL: shuffle5_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.16 q1, q0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @shuffle6_i16(<8 x i16> %src) {
; CHECK-LABEL: shuffle6_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src, <8 x i16> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @oneoff11_i16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: oneoff11_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q0[1]
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src1, <8 x i16> %src2, <8 x i32> <i32 0, i32 1, i32 1, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @oneoff12_i16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: oneoff12_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q1[0]
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src1, <8 x i16> %src2, <8 x i32> <i32 8, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @oneoff21_i16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: oneoff21_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vins.f16 s5, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src1, <8 x i16> %src2, <8 x i32> <i32 8, i32 9, i32 10, i32 0, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @oneoff22_i16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: oneoff22_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmov.u16 r0, q1[6]
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src1, <8 x i16> %src2, <8 x i32> <i32 14, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @oneoffundef_i16(<8 x i16> %src1, <8 x i16> %src2) {
; CHECK-LABEL: oneoffundef_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    vmov.16 q1[5], r0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x i16> %src1, <8 x i16> %src2, <8 x i32> <i32 8, i32 9, i32 undef, i32 undef, i32 12, i32 3, i32 14, i32 15>
  ret <8 x i16> %out
}

define arm_aapcs_vfpcc <8 x i16> @shuffle2step_i16(<16 x i16> %src) {
; CHECK-LABEL: shuffle2step_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    mov r0, sp
; CHECK-NEXT:    vshr.u32 q2, q1, #16
; CHECK-NEXT:    vstrh.32 q2, [r0, #8]
; CHECK-NEXT:    vshr.u32 q2, q0, #16
; CHECK-NEXT:    add r1, sp, #16
; CHECK-NEXT:    vstrh.32 q2, [r0]
; CHECK-NEXT:    vstrh.32 q1, [r1, #8]
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r1]
; CHECK-NEXT:    vadd.i16 q0, q1, q0
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x i16> %src, <16 x i16> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x i16> %src, <16 x i16> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %r = add <8 x i16> %s1, %s2
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @shuffle3step_i16(<32 x i16> %src) {
; CHECK-LABEL: shuffle3step_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9}
; CHECK-NEXT:    vpush {d8, d9}
; CHECK-NEXT:    vmovx.f16 s12, s0
; CHECK-NEXT:    vmov.f32 s16, s1
; CHECK-NEXT:    vins.f16 s12, s2
; CHECK-NEXT:    vmovx.f16 s2, s2
; CHECK-NEXT:    vins.f16 s16, s2
; CHECK-NEXT:    vmovx.f16 s2, s5
; CHECK-NEXT:    vmov.f32 s17, s4
; CHECK-NEXT:    vmovx.f16 s14, s6
; CHECK-NEXT:    vins.f16 s17, s2
; CHECK-NEXT:    vmovx.f16 s2, s8
; CHECK-NEXT:    vmov.f32 s18, s7
; CHECK-NEXT:    vins.f16 s14, s8
; CHECK-NEXT:    vins.f16 s18, s2
; CHECK-NEXT:    vmovx.f16 s2, s11
; CHECK-NEXT:    vmovx.f16 s8, s10
; CHECK-NEXT:    vins.f16 s10, s2
; CHECK-NEXT:    vmovx.f16 s2, s1
; CHECK-NEXT:    vmovx.f16 s13, s3
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vmovx.f16 s2, s4
; CHECK-NEXT:    vins.f16 s3, s2
; CHECK-NEXT:    vmovx.f16 s2, s7
; CHECK-NEXT:    vmovx.f16 s15, s9
; CHECK-NEXT:    vins.f16 s6, s2
; CHECK-NEXT:    vins.f16 s9, s8
; CHECK-NEXT:    vmov.f32 s1, s3
; CHECK-NEXT:    vins.f16 s15, s11
; CHECK-NEXT:    vins.f16 s13, s5
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vmov.f32 s3, s9
; CHECK-NEXT:    vmov.f32 s19, s10
; CHECK-NEXT:    vadd.i16 q0, q0, q3
; CHECK-NEXT:    vadd.i16 q0, q0, q4
; CHECK-NEXT:    vpop {d8, d9}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %s2 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %s3 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  %a = add <8 x i16> %s1, %s2
  %r = add <8 x i16> %a, %s3
  ret <8 x i16> %r
}

define arm_aapcs_vfpcc <8 x i16> @shuffle4step_i16(<32 x i16> %src) {
; CHECK-LABEL: shuffle4step_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vmovx.f16 s18, s9
; CHECK-NEXT:    vmovx.f16 s16, s11
; CHECK-NEXT:    vins.f16 s18, s16
; CHECK-NEXT:    vmovx.f16 s19, s13
; CHECK-NEXT:    vmovx.f16 s16, s15
; CHECK-NEXT:    vmovx.f16 s20, s3
; CHECK-NEXT:    vins.f16 s19, s16
; CHECK-NEXT:    vmovx.f16 s16, s1
; CHECK-NEXT:    vins.f16 s16, s20
; CHECK-NEXT:    vmovx.f16 s17, s5
; CHECK-NEXT:    vmovx.f16 s20, s7
; CHECK-NEXT:    vins.f16 s9, s11
; CHECK-NEXT:    vins.f16 s13, s15
; CHECK-NEXT:    vins.f16 s5, s7
; CHECK-NEXT:    vins.f16 s1, s3
; CHECK-NEXT:    vins.f16 s17, s20
; CHECK-NEXT:    vmov.f32 s20, s1
; CHECK-NEXT:    vmovx.f16 s1, s10
; CHECK-NEXT:    vmov.f32 s22, s9
; CHECK-NEXT:    vmov.f32 s21, s5
; CHECK-NEXT:    vmov.f32 s23, s13
; CHECK-NEXT:    vadd.i16 q4, q5, q4
; CHECK-NEXT:    vmovx.f16 s22, s8
; CHECK-NEXT:    vins.f16 s22, s1
; CHECK-NEXT:    vmovx.f16 s23, s12
; CHECK-NEXT:    vmovx.f16 s1, s14
; CHECK-NEXT:    vmovx.f16 s20, s0
; CHECK-NEXT:    vins.f16 s23, s1
; CHECK-NEXT:    vmovx.f16 s1, s2
; CHECK-NEXT:    vins.f16 s20, s1
; CHECK-NEXT:    vmovx.f16 s21, s4
; CHECK-NEXT:    vmovx.f16 s1, s6
; CHECK-NEXT:    vins.f16 s12, s14
; CHECK-NEXT:    vins.f16 s8, s10
; CHECK-NEXT:    vins.f16 s4, s6
; CHECK-NEXT:    vins.f16 s21, s1
; CHECK-NEXT:    vins.f16 s0, s2
; CHECK-NEXT:    vmov.f32 s1, s4
; CHECK-NEXT:    vmov.f32 s2, s8
; CHECK-NEXT:    vmov.f32 s3, s12
; CHECK-NEXT:    vadd.i16 q0, q0, q5
; CHECK-NEXT:    vadd.i16 q0, q0, q4
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x i16> %src, <32 x i16> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = add <8 x i16> %s1, %s2
  %a2 = add <8 x i16> %s3, %s4
  %r = add <8 x i16> %a1, %a2
  ret <8 x i16> %r
}

; i8

define arm_aapcs_vfpcc <16 x i8> @shuffle1_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle1_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.8 q1, q0
; CHECK-NEXT:    vmov.f32 s0, s6
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8, i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle2_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle2_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle3_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle3_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q1, q0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.8 q0[0], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.8 q0[1], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q0[2], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q0[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q0[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q0[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q0[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[3]
; CHECK-NEXT:    vmov.8 q0[7], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 4, i32 5, i32 15, i32 7, i32 14, i32 9, i32 6, i32 3, i32 10, i32 12, i32 1, i32 13, i32 2, i32 8, i32 0, i32 11>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle5_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle5_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.8 q1, q0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0, i32 15, i32 14, i32 13, i32 12, i32 11, i32 10, i32 9, i32 8>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle6_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle6_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4, i32 11, i32 10, i32 9, i32 8, i32 15, i32 14, i32 13, i32 12>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle7_i8(<16 x i8> %src) {
; CHECK-LABEL: shuffle7_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev16.8 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src, <16 x i8> undef, <16 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6, i32 9, i32 8, i32 11, i32 10, i32 13, i32 12, i32 15, i32 14>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @oneoff11_i8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: oneoff11_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.8 q0[2], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src1, <16 x i8> %src2, <16 x i32> <i32 0, i32 1, i32 1, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @oneoff12_i8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: oneoff12_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.8 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src1, <16 x i8> %src2, <16 x i32> <i32 20, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7, i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @oneoff21_i8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: oneoff21_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    vmov.8 q1[3], r0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src1, <16 x i8> %src2, <16 x i32> <i32 16, i32 17, i32 18, i32 0, i32 20, i32 21, i32 22, i32 23, i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @oneoff22_i8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: oneoff22_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src1, <16 x i8> %src2, <16 x i32> <i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23, i32 24, i32 31, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @oneoffundef_i8(<16 x i8> %src1, <16 x i8> %src2) {
; CHECK-LABEL: oneoffundef_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.8 q0[1], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <16 x i8> %src1, <16 x i8> %src2, <16 x i32> <i32 undef, i32 2, i32 2, i32 3, i32 undef, i32 5, i32 6, i32 7, i32 undef, i32 9, i32 10, i32 11, i32 undef, i32 13, i32 14, i32 15>
  ret <16 x i8> %out
}

define arm_aapcs_vfpcc <16 x i8> @shuffle2step_i8(<32 x i8> %src) {
; CHECK-LABEL: shuffle2step_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .pad #32
; CHECK-NEXT:    sub sp, #32
; CHECK-NEXT:    mov r0, sp
; CHECK-NEXT:    vshr.u16 q2, q1, #8
; CHECK-NEXT:    vstrb.16 q2, [r0, #8]
; CHECK-NEXT:    vshr.u16 q2, q0, #8
; CHECK-NEXT:    add r1, sp, #16
; CHECK-NEXT:    vstrb.16 q2, [r0]
; CHECK-NEXT:    vstrb.16 q1, [r1, #8]
; CHECK-NEXT:    vstrb.16 q0, [r1]
; CHECK-NEXT:    vldrw.u32 q0, [r0]
; CHECK-NEXT:    vldrw.u32 q1, [r1]
; CHECK-NEXT:    vadd.i8 q0, q1, q0
; CHECK-NEXT:    add sp, #32
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <32 x i8> %src, <32 x i8> undef, <16 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14, i32 16, i32 18, i32 20, i32 22, i32 24, i32 26, i32 28, i32 30>
  %s2 = shufflevector <32 x i8> %src, <32 x i8> undef, <16 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15, i32 17, i32 19, i32 21, i32 23, i32 25, i32 27, i32 29, i32 31>
  %r = add <16 x i8> %s1, %s2
  ret <16 x i8> %r
}

define arm_aapcs_vfpcc <16 x i8> @shuffle3step_i8(<64 x i8> %src) {
; CHECK-LABEL: shuffle3step_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.8 q3[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.8 q3[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.8 q3[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.8 q3[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.8 q3[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vmov.8 q3[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[3]
; CHECK-NEXT:    vmov.8 q3[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q4[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q4[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q4[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[2]
; CHECK-NEXT:    vmov.8 q4[11], r0
; CHECK-NEXT:    vmov.u8 r0, q2[5]
; CHECK-NEXT:    vmov.8 q4[12], r0
; CHECK-NEXT:    vmov.u8 r0, q2[8]
; CHECK-NEXT:    vmov.8 q4[13], r0
; CHECK-NEXT:    vmov.u8 r0, q2[11]
; CHECK-NEXT:    vmov.8 q4[14], r0
; CHECK-NEXT:    vmov.u8 r0, q2[14]
; CHECK-NEXT:    vmov.8 q4[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q3[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    vmov.f32 s14, s18
; CHECK-NEXT:    vmov.f32 s15, s19
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q5[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[1]
; CHECK-NEXT:    vmov.8 q5[11], r0
; CHECK-NEXT:    vmov.u8 r0, q2[4]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q2[7]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q2[10]
; CHECK-NEXT:    vmov.8 q5[14], r0
; CHECK-NEXT:    vmov.u8 r0, q2[13]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.f32 s18, s22
; CHECK-NEXT:    vmov.f32 s19, s23
; CHECK-NEXT:    vadd.i8 q3, q4, q3
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[8]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[0]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[3]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u8 r0, q2[6]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u8 r0, q2[9]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u8 r0, q2[12]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u8 r0, q2[15]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.f32 s18, s2
; CHECK-NEXT:    vmov.f32 s19, s3
; CHECK-NEXT:    vadd.i8 q0, q3, q4
; CHECK-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21, i32 24, i32 27, i32 30, i32 33, i32 36, i32 39, i32 42, i32 45>
  %s2 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22, i32 25, i32 28, i32 31, i32 34, i32 37, i32 40, i32 43, i32 46>
  %s3 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23, i32 26, i32 29, i32 32, i32 35, i32 38, i32 41, i32 44, i32 47>
  %a = add <16 x i8> %s1, %s2
  %r = add <16 x i8> %a, %s3
  ret <16 x i8> %r
}

define arm_aapcs_vfpcc <16 x i8> @shuffle4step_i8(<64 x i8> %src) {
; CHECK-LABEL: shuffle4step_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    vmov.8 q4[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[7]
; CHECK-NEXT:    vmov.8 q4[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[11]
; CHECK-NEXT:    vmov.8 q4[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[15]
; CHECK-NEXT:    vmov.8 q4[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[3]
; CHECK-NEXT:    vmov.8 q4[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[7]
; CHECK-NEXT:    vmov.8 q4[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[11]
; CHECK-NEXT:    vmov.8 q4[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[3]
; CHECK-NEXT:    vmov.8 q5[8], r0
; CHECK-NEXT:    vmov.u8 r0, q2[7]
; CHECK-NEXT:    vmov.8 q5[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[11]
; CHECK-NEXT:    vmov.8 q5[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[15]
; CHECK-NEXT:    vmov.8 q5[11], r0
; CHECK-NEXT:    vmov.u8 r0, q3[3]
; CHECK-NEXT:    vmov.8 q5[12], r0
; CHECK-NEXT:    vmov.u8 r0, q3[7]
; CHECK-NEXT:    vmov.8 q5[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[11]
; CHECK-NEXT:    vmov.8 q5[14], r0
; CHECK-NEXT:    vmov.u8 r0, q3[15]
; CHECK-NEXT:    vmov.8 q5[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[15]
; CHECK-NEXT:    vmov.8 q4[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[2]
; CHECK-NEXT:    vmov.f32 s18, s22
; CHECK-NEXT:    vmov.f32 s19, s23
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[6]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[10]
; CHECK-NEXT:    vmov.8 q5[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[14]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[2]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[6]
; CHECK-NEXT:    vmov.8 q5[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[10]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[2]
; CHECK-NEXT:    vmov.8 q6[8], r0
; CHECK-NEXT:    vmov.u8 r0, q2[6]
; CHECK-NEXT:    vmov.8 q6[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[10]
; CHECK-NEXT:    vmov.8 q6[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[14]
; CHECK-NEXT:    vmov.8 q6[11], r0
; CHECK-NEXT:    vmov.u8 r0, q3[2]
; CHECK-NEXT:    vmov.8 q6[12], r0
; CHECK-NEXT:    vmov.u8 r0, q3[6]
; CHECK-NEXT:    vmov.8 q6[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[10]
; CHECK-NEXT:    vmov.8 q6[14], r0
; CHECK-NEXT:    vmov.u8 r0, q3[14]
; CHECK-NEXT:    vmov.8 q6[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[14]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[1]
; CHECK-NEXT:    vmov.f32 s22, s26
; CHECK-NEXT:    vmov.f32 s23, s27
; CHECK-NEXT:    vadd.i8 q4, q5, q4
; CHECK-NEXT:    vmov.8 q5[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[5]
; CHECK-NEXT:    vmov.8 q5[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[9]
; CHECK-NEXT:    vmov.8 q5[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[13]
; CHECK-NEXT:    vmov.8 q5[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[1]
; CHECK-NEXT:    vmov.8 q5[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[5]
; CHECK-NEXT:    vmov.8 q5[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[9]
; CHECK-NEXT:    vmov.8 q5[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[1]
; CHECK-NEXT:    vmov.8 q6[8], r0
; CHECK-NEXT:    vmov.u8 r0, q2[5]
; CHECK-NEXT:    vmov.8 q6[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[9]
; CHECK-NEXT:    vmov.8 q6[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[13]
; CHECK-NEXT:    vmov.8 q6[11], r0
; CHECK-NEXT:    vmov.u8 r0, q3[1]
; CHECK-NEXT:    vmov.8 q6[12], r0
; CHECK-NEXT:    vmov.u8 r0, q3[5]
; CHECK-NEXT:    vmov.8 q6[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[9]
; CHECK-NEXT:    vmov.8 q6[14], r0
; CHECK-NEXT:    vmov.u8 r0, q3[13]
; CHECK-NEXT:    vmov.8 q6[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[13]
; CHECK-NEXT:    vmov.8 q5[7], r0
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    vmov.f32 s22, s26
; CHECK-NEXT:    vmov.f32 s23, s27
; CHECK-NEXT:    vmov.8 q6[0], r0
; CHECK-NEXT:    vmov.u8 r0, q0[4]
; CHECK-NEXT:    vmov.8 q6[1], r0
; CHECK-NEXT:    vmov.u8 r0, q0[8]
; CHECK-NEXT:    vmov.8 q6[2], r0
; CHECK-NEXT:    vmov.u8 r0, q0[12]
; CHECK-NEXT:    vmov.8 q6[3], r0
; CHECK-NEXT:    vmov.u8 r0, q1[0]
; CHECK-NEXT:    vmov.8 q6[4], r0
; CHECK-NEXT:    vmov.u8 r0, q1[4]
; CHECK-NEXT:    vmov.8 q6[5], r0
; CHECK-NEXT:    vmov.u8 r0, q1[8]
; CHECK-NEXT:    vmov.8 q6[6], r0
; CHECK-NEXT:    vmov.u8 r0, q2[0]
; CHECK-NEXT:    vmov.8 q0[8], r0
; CHECK-NEXT:    vmov.u8 r0, q2[4]
; CHECK-NEXT:    vmov.8 q0[9], r0
; CHECK-NEXT:    vmov.u8 r0, q2[8]
; CHECK-NEXT:    vmov.8 q0[10], r0
; CHECK-NEXT:    vmov.u8 r0, q2[12]
; CHECK-NEXT:    vmov.8 q0[11], r0
; CHECK-NEXT:    vmov.u8 r0, q3[0]
; CHECK-NEXT:    vmov.8 q0[12], r0
; CHECK-NEXT:    vmov.u8 r0, q3[4]
; CHECK-NEXT:    vmov.8 q0[13], r0
; CHECK-NEXT:    vmov.u8 r0, q3[8]
; CHECK-NEXT:    vmov.8 q0[14], r0
; CHECK-NEXT:    vmov.u8 r0, q3[12]
; CHECK-NEXT:    vmov.8 q0[15], r0
; CHECK-NEXT:    vmov.u8 r0, q1[12]
; CHECK-NEXT:    vmov.8 q6[7], r0
; CHECK-NEXT:    vmov.f32 s26, s2
; CHECK-NEXT:    vmov.f32 s27, s3
; CHECK-NEXT:    vadd.i8 q0, q6, q5
; CHECK-NEXT:    vadd.i8 q0, q0, q4
; CHECK-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECK-NEXT:    bx lr
entry:
  %s1 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28, i32 32, i32 36, i32 40, i32 44, i32 48, i32 52, i32 56, i32 60>
  %s2 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29, i32 33, i32 37, i32 41, i32 45, i32 49, i32 53, i32 57, i32 61>
  %s3 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30, i32 34, i32 38, i32 42, i32 46, i32 50, i32 54, i32 58, i32 62>
  %s4 = shufflevector <64 x i8> %src, <64 x i8> undef, <16 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31, i32 35, i32 39, i32 43, i32 47, i32 51, i32 55, i32 59, i32 63>
  %a1 = add <16 x i8> %s1, %s2
  %a2 = add <16 x i8> %s3, %s4
  %r = add <16 x i8> %a1, %a2
  ret <16 x i8> %r
}

; i64

define arm_aapcs_vfpcc <2 x i64> @shuffle1_i64(<2 x i64> %src) {
; CHECK-LABEL: shuffle1_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src, <2 x i64> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x i64> %out
}

define arm_aapcs_vfpcc <2 x i64> @shuffle2_i64(<2 x i64> %src) {
; CHECK-LABEL: shuffle2_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src, <2 x i64> undef, <2 x i32> <i32 1, i32 0>
  ret <2 x i64> %out
}

define arm_aapcs_vfpcc <2 x i64> @shuffle3_i64(<2 x i64> %src) {
; CHECK-LABEL: shuffle3_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src, <2 x i64> undef, <2 x i32> <i32 undef, i32 1>
  ret <2 x i64> %out
}

; f32

define arm_aapcs_vfpcc <4 x float> @shuffle1_f32(<4 x float> %src) {
; CHECK-LABEL: shuffle1_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s3
; CHECK-NEXT:    vmov.f32 s5, s2
; CHECK-NEXT:    vmov.f32 s6, s1
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src, <4 x float> undef, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @shuffle2_f32(<4 x float> %src) {
; CHECK-LABEL: shuffle2_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src, <4 x float> undef, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @shuffle3_f32(<4 x float> %src) {
; CHECK-LABEL: shuffle3_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s3
; CHECK-NEXT:    vmov.f32 s5, s1
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src, <4 x float> undef, <4 x i32> <i32 3, i32 1, i32 2, i32 0>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @shuffle5_f32(<4 x float> %src) {
; CHECK-LABEL: shuffle5_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.32 q1, q0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src, <4 x float> undef, <4 x i32> <i32 1, i32 0, i32 3, i32 2>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @oneoff11_f32(<4 x float> %src1, <4 x float> %src2) {
; CHECK-LABEL: oneoff11_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s2, s1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src1, <4 x float> %src2, <4 x i32> <i32 0, i32 1, i32 1, i32 3>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @oneoff12_f32(<4 x float> %src1, <4 x float> %src2) {
; CHECK-LABEL: oneoff12_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s4
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src1, <4 x float> %src2, <4 x i32> <i32 4, i32 1, i32 2, i32 3>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @oneoff21_f32(<4 x float> %src1, <4 x float> %src2) {
; CHECK-LABEL: oneoff21_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s7, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src1, <4 x float> %src2, <4 x i32> <i32 4, i32 5, i32 6, i32 0>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @oneoff22_f32(<4 x float> %src1, <4 x float> %src2) {
; CHECK-LABEL: oneoff22_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmov.f32 s2, s0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <4 x float> %src1, <4 x float> %src2, <4 x i32> <i32 4, i32 5, i32 4, i32 7>
  ret <4 x float> %out
}

define arm_aapcs_vfpcc <4 x float> @shuffle2step_f32(<8 x float> %src) {
; CHECKFP-LABEL: shuffle2step_f32:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    vmov.f32 s8, s1
; CHECKFP-NEXT:    vmov.f32 s9, s3
; CHECKFP-NEXT:    vmov.f32 s1, s2
; CHECKFP-NEXT:    vmov.f32 s10, s5
; CHECKFP-NEXT:    vmov.f32 s11, s7
; CHECKFP-NEXT:    vmov.f32 s2, s4
; CHECKFP-NEXT:    vmov.f32 s3, s6
; CHECKFP-NEXT:    vadd.f32 q0, q0, q2
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <8 x float> %src, <8 x float> undef, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
  %s2 = shufflevector <8 x float> %src, <8 x float> undef, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
  %r = fadd <4 x float> %s1, %s2
  ret <4 x float> %r
}

define arm_aapcs_vfpcc <4 x float> @shuffle3step_f32(<16 x float> %src) {
; CHECKFP-LABEL: shuffle3step_f32:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    .vsave {d8, d9}
; CHECKFP-NEXT:    vpush {d8, d9}
; CHECKFP-NEXT:    vmov.f32 s13, s4
; CHECKFP-NEXT:    vmov.f32 s14, s7
; CHECKFP-NEXT:    vmov.f32 s18, s6
; CHECKFP-NEXT:    vmov.f32 s12, s1
; CHECKFP-NEXT:    vmov.f32 s15, s10
; CHECKFP-NEXT:    vmov.f32 s16, s0
; CHECKFP-NEXT:    vmov.f32 s17, s3
; CHECKFP-NEXT:    vmov.f32 s19, s9
; CHECKFP-NEXT:    vadd.f32 q3, q4, q3
; CHECKFP-NEXT:    vmov.f32 s4, s2
; CHECKFP-NEXT:    vmov.f32 s6, s8
; CHECKFP-NEXT:    vmov.f32 s7, s11
; CHECKFP-NEXT:    vadd.f32 q0, q3, q1
; CHECKFP-NEXT:    vpop {d8, d9}
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 0, i32 3, i32 6, i32 9>
  %s2 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 1, i32 4, i32 7, i32 10>
  %s3 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 2, i32 5, i32 8, i32 11>
  %a = fadd <4 x float> %s1, %s2
  %r = fadd <4 x float> %a, %s3
  ret <4 x float> %r
}

define arm_aapcs_vfpcc <4 x float> @shuffle4step_f32(<16 x float> %src) {
; CHECKFP-LABEL: shuffle4step_f32:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    .vsave {d8, d9, d10, d11}
; CHECKFP-NEXT:    vpush {d8, d9, d10, d11}
; CHECKFP-NEXT:    vmov.f32 s16, s3
; CHECKFP-NEXT:    vmov.f32 s20, s2
; CHECKFP-NEXT:    vmov.f32 s17, s7
; CHECKFP-NEXT:    vmov.f32 s18, s11
; CHECKFP-NEXT:    vmov.f32 s19, s15
; CHECKFP-NEXT:    vmov.f32 s21, s6
; CHECKFP-NEXT:    vmov.f32 s22, s10
; CHECKFP-NEXT:    vmov.f32 s23, s14
; CHECKFP-NEXT:    vadd.f32 q4, q5, q4
; CHECKFP-NEXT:    vmov.f32 s20, s1
; CHECKFP-NEXT:    vmov.f32 s21, s5
; CHECKFP-NEXT:    vmov.f32 s22, s9
; CHECKFP-NEXT:    vmov.f32 s23, s13
; CHECKFP-NEXT:    vmov.f32 s1, s4
; CHECKFP-NEXT:    vmov.f32 s2, s8
; CHECKFP-NEXT:    vmov.f32 s3, s12
; CHECKFP-NEXT:    vadd.f32 q0, q0, q5
; CHECKFP-NEXT:    vadd.f32 q0, q0, q4
; CHECKFP-NEXT:    vpop {d8, d9, d10, d11}
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 0, i32 4, i32 8, i32 12>
  %s2 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 1, i32 5, i32 9, i32 13>
  %s3 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 2, i32 6, i32 10, i32 14>
  %s4 = shufflevector <16 x float> %src, <16 x float> undef, <4 x i32> <i32 3, i32 7, i32 11, i32 15>
  %a1 = fadd <4 x float> %s1, %s2
  %a2 = fadd <4 x float> %s3, %s4
  %r = fadd <4 x float> %a1, %a2
  ret <4 x float> %r
}

; f16

define arm_aapcs_vfpcc <8 x half> @shuffle1_f16(<8 x half> %src) {
; CHECK-LABEL: shuffle1_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.16 q1, q0
; CHECK-NEXT:    vmov.f32 s0, s6
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    vmov.f32 s2, s4
; CHECK-NEXT:    vmov.f32 s3, s5
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 7, i32 6, i32 5, i32 4, i32 3, i32 2, i32 1, i32 0>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @shuffle2_f16(<8 x half> %src) {
; CHECK-LABEL: shuffle2_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @shuffle3_f16(<8 x half> %src) {
; CHECK-LV-LABEL: shuffle3_f16:
; CHECK-LV:       @ %bb.0: @ %entry
; CHECK-LV-NEXT:    vmovx.f16 s5, s3
; CHECK-LV-NEXT:    vmovx.f16 s6, s1
; CHECK-LV-NEXT:    vmovx.f16 s4, s0
; CHECK-LV-NEXT:    vins.f16 s1, s0
; CHECK-LV-NEXT:    vins.f16 s6, s4
; CHECK-LV-NEXT:    vins.f16 s5, s3
; CHECK-LV-NEXT:    vmov.f32 s4, s2
; CHECK-LV-NEXT:    vmov.f32 s7, s1
; CHECK-LV-NEXT:    vmov q0, q1
; CHECK-LV-NEXT:    bx lr
;
; CHECK-LIS-LABEL: shuffle3_f16:
; CHECK-LIS:       @ %bb.0: @ %entry
; CHECK-LIS-NEXT:    vmov q1, q0
; CHECK-LIS-NEXT:    vmovx.f16 s2, s5
; CHECK-LIS-NEXT:    vmovx.f16 s0, s4
; CHECK-LIS-NEXT:    vins.f16 s5, s4
; CHECK-LIS-NEXT:    vins.f16 s2, s0
; CHECK-LIS-NEXT:    vmov.f32 s0, s6
; CHECK-LIS-NEXT:    vmovx.f16 s1, s7
; CHECK-LIS-NEXT:    vmov.f32 s3, s5
; CHECK-LIS-NEXT:    vins.f16 s1, s7
; CHECK-LIS-NEXT:    bx lr

entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 4, i32 5, i32 7, i32 6, i32 3, i32 1, i32 2, i32 0>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @shuffle5_f16(<8 x half> %src) {
; CHECK-LABEL: shuffle5_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev64.16 q1, q0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 3, i32 2, i32 1, i32 0, i32 7, i32 6, i32 5, i32 4>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @shuffle6_f16(<8 x half> %src) {
; CHECK-LABEL: shuffle6_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vrev32.16 q0, q0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src, <8 x half> undef, <8 x i32> <i32 1, i32 0, i32 3, i32 2, i32 5, i32 4, i32 7, i32 6>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @oneoff11_f16(<8 x half> %src1, <8 x half> %src2) {
; CHECK-LABEL: oneoff11_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovx.f16 s4, s0
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.16 q0[2], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src1, <8 x half> %src2, <8 x i32> <i32 0, i32 1, i32 1, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @oneoff12_f16(<8 x half> %src1, <8 x half> %src2) {
; CHECK-LABEL: oneoff12_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s4
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src1, <8 x half> %src2, <8 x i32> <i32 8, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @oneoff21_f16(<8 x half> %src1, <8 x half> %src2) {
; CHECK-LABEL: oneoff21_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vins.f16 s5, s0
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src1, <8 x half> %src2, <8 x i32> <i32 8, i32 9, i32 10, i32 0, i32 12, i32 13, i32 14, i32 15>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @oneoff22_f16(<8 x half> %src1, <8 x half> %src2) {
; CHECK-LABEL: oneoff22_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <8 x half> %src1, <8 x half> %src2, <8 x i32> <i32 14, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <8 x half> %out
}

define arm_aapcs_vfpcc <8 x half> @shuffle2step_f16(<16 x half> %src) {
; CHECKFP-LABEL: shuffle2step_f16:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    vmovx.f16 s8, s0
; CHECKFP-NEXT:    vmovx.f16 s10, s1
; CHECKFP-NEXT:    vins.f16 s8, s10
; CHECKFP-NEXT:    vmovx.f16 s9, s2
; CHECKFP-NEXT:    vmovx.f16 s10, s3
; CHECKFP-NEXT:    vmovx.f16 s12, s5
; CHECKFP-NEXT:    vins.f16 s9, s10
; CHECKFP-NEXT:    vmovx.f16 s10, s4
; CHECKFP-NEXT:    vins.f16 s10, s12
; CHECKFP-NEXT:    vmovx.f16 s11, s6
; CHECKFP-NEXT:    vmovx.f16 s12, s7
; CHECKFP-NEXT:    vins.f16 s2, s3
; CHECKFP-NEXT:    vins.f16 s6, s7
; CHECKFP-NEXT:    vins.f16 s4, s5
; CHECKFP-NEXT:    vins.f16 s0, s1
; CHECKFP-NEXT:    vmov.f32 s1, s2
; CHECKFP-NEXT:    vins.f16 s11, s12
; CHECKFP-NEXT:    vmov.f32 s2, s4
; CHECKFP-NEXT:    vmov.f32 s3, s6
; CHECKFP-NEXT:    vadd.f16 q0, q0, q2
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <16 x half> %src, <16 x half> undef, <8 x i32> <i32 0, i32 2, i32 4, i32 6, i32 8, i32 10, i32 12, i32 14>
  %s2 = shufflevector <16 x half> %src, <16 x half> undef, <8 x i32> <i32 1, i32 3, i32 5, i32 7, i32 9, i32 11, i32 13, i32 15>
  %r = fadd <8 x half> %s1, %s2
  ret <8 x half> %r
}

define arm_aapcs_vfpcc <8 x half> @shuffle3step_f16(<32 x half> %src) {
; CHECKFP-LABEL: shuffle3step_f16:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    .vsave {d8, d9}
; CHECKFP-NEXT:    vpush {d8, d9}
; CHECKFP-NEXT:    vmov.f32 s13, s4
; CHECKFP-NEXT:    vmovx.f16 s4, s4
; CHECKFP-NEXT:    vmovx.f16 s17, s3
; CHECKFP-NEXT:    vins.f16 s3, s4
; CHECKFP-NEXT:    vmovx.f16 s4, s7
; CHECKFP-NEXT:    vmovx.f16 s18, s6
; CHECKFP-NEXT:    vmovx.f16 s16, s0
; CHECKFP-NEXT:    vins.f16 s6, s4
; CHECKFP-NEXT:    vmovx.f16 s14, s2
; CHECKFP-NEXT:    vmov.f32 s12, s1
; CHECKFP-NEXT:    vmovx.f16 s4, s10
; CHECKFP-NEXT:    vmovx.f16 s19, s9
; CHECKFP-NEXT:    vins.f16 s12, s14
; CHECKFP-NEXT:    vmovx.f16 s14, s5
; CHECKFP-NEXT:    vins.f16 s16, s2
; CHECKFP-NEXT:    vmovx.f16 s2, s11
; CHECKFP-NEXT:    vmovx.f16 s15, s8
; CHECKFP-NEXT:    vins.f16 s18, s8
; CHECKFP-NEXT:    vmovx.f16 s8, s1
; CHECKFP-NEXT:    vins.f16 s9, s4
; CHECKFP-NEXT:    vins.f16 s13, s14
; CHECKFP-NEXT:    vmov.f32 s14, s7
; CHECKFP-NEXT:    vins.f16 s10, s2
; CHECKFP-NEXT:    vmov.f32 s1, s3
; CHECKFP-NEXT:    vins.f16 s19, s11
; CHECKFP-NEXT:    vins.f16 s17, s5
; CHECKFP-NEXT:    vins.f16 s0, s8
; CHECKFP-NEXT:    vmov.f32 s2, s6
; CHECKFP-NEXT:    vmov.f32 s3, s9
; CHECKFP-NEXT:    vins.f16 s14, s15
; CHECKFP-NEXT:    vmov.f32 s15, s10
; CHECKFP-NEXT:    vadd.f16 q0, q0, q4
; CHECKFP-NEXT:    vadd.f16 q0, q0, q3
; CHECKFP-NEXT:    vpop {d8, d9}
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 0, i32 3, i32 6, i32 9, i32 12, i32 15, i32 18, i32 21>
  %s2 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 1, i32 4, i32 7, i32 10, i32 13, i32 16, i32 19, i32 22>
  %s3 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 2, i32 5, i32 8, i32 11, i32 14, i32 17, i32 20, i32 23>
  %a = fadd <8 x half> %s1, %s2
  %r = fadd <8 x half> %a, %s3
  ret <8 x half> %r
}

define arm_aapcs_vfpcc <8 x half> @shuffle4step_f16(<32 x half> %src) {
; CHECKFP-LABEL: shuffle4step_f16:
; CHECKFP:       @ %bb.0: @ %entry
; CHECKFP-NEXT:    .vsave {d8, d9, d10, d11, d12, d13}
; CHECKFP-NEXT:    vpush {d8, d9, d10, d11, d12, d13}
; CHECKFP-NEXT:    vmovx.f16 s18, s9
; CHECKFP-NEXT:    vmovx.f16 s16, s11
; CHECKFP-NEXT:    vins.f16 s18, s16
; CHECKFP-NEXT:    vmovx.f16 s19, s13
; CHECKFP-NEXT:    vmovx.f16 s16, s15
; CHECKFP-NEXT:    vmovx.f16 s22, s8
; CHECKFP-NEXT:    vins.f16 s19, s16
; CHECKFP-NEXT:    vmovx.f16 s16, s1
; CHECKFP-NEXT:    vmovx.f16 s20, s3
; CHECKFP-NEXT:    vins.f16 s1, s3
; CHECKFP-NEXT:    vmovx.f16 s3, s10
; CHECKFP-NEXT:    vins.f16 s16, s20
; CHECKFP-NEXT:    vmovx.f16 s17, s5
; CHECKFP-NEXT:    vmovx.f16 s20, s7
; CHECKFP-NEXT:    vins.f16 s22, s3
; CHECKFP-NEXT:    vmovx.f16 s23, s12
; CHECKFP-NEXT:    vmovx.f16 s3, s14
; CHECKFP-NEXT:    vins.f16 s17, s20
; CHECKFP-NEXT:    vins.f16 s23, s3
; CHECKFP-NEXT:    vmovx.f16 s20, s0
; CHECKFP-NEXT:    vmovx.f16 s3, s2
; CHECKFP-NEXT:    vins.f16 s9, s11
; CHECKFP-NEXT:    vins.f16 s13, s15
; CHECKFP-NEXT:    vins.f16 s5, s7
; CHECKFP-NEXT:    vins.f16 s20, s3
; CHECKFP-NEXT:    vmovx.f16 s21, s4
; CHECKFP-NEXT:    vmovx.f16 s3, s6
; CHECKFP-NEXT:    vins.f16 s8, s10
; CHECKFP-NEXT:    vins.f16 s12, s14
; CHECKFP-NEXT:    vins.f16 s4, s6
; CHECKFP-NEXT:    vins.f16 s21, s3
; CHECKFP-NEXT:    vins.f16 s0, s2
; CHECKFP-NEXT:    vmov.f32 s24, s1
; CHECKFP-NEXT:    vmov.f32 s26, s9
; CHECKFP-NEXT:    vmov.f32 s25, s5
; CHECKFP-NEXT:    vmov.f32 s27, s13
; CHECKFP-NEXT:    vmov.f32 s2, s8
; CHECKFP-NEXT:    vadd.f16 q4, q6, q4
; CHECKFP-NEXT:    vmov.f32 s1, s4
; CHECKFP-NEXT:    vmov.f32 s3, s12
; CHECKFP-NEXT:    vadd.f16 q0, q0, q5
; CHECKFP-NEXT:    vadd.f16 q0, q0, q4
; CHECKFP-NEXT:    vpop {d8, d9, d10, d11, d12, d13}
; CHECKFP-NEXT:    bx lr
entry:
  %s1 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 0, i32 4, i32 8, i32 12, i32 16, i32 20, i32 24, i32 28>
  %s2 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 1, i32 5, i32 9, i32 13, i32 17, i32 21, i32 25, i32 29>
  %s3 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 2, i32 6, i32 10, i32 14, i32 18, i32 22, i32 26, i32 30>
  %s4 = shufflevector <32 x half> %src, <32 x half> undef, <8 x i32> <i32 3, i32 7, i32 11, i32 15, i32 19, i32 23, i32 27, i32 31>
  %a1 = fadd <8 x half> %s1, %s2
  %a2 = fadd <8 x half> %s3, %s4
  %r = fadd <8 x half> %a1, %a2
  ret <8 x half> %r
}

; f64

define arm_aapcs_vfpcc <2 x double> @shuffle1_f64(<2 x double> %src) {
; CHECK-LABEL: shuffle1_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src, <2 x double> undef, <2 x i32> <i32 0, i32 1>
  ret <2 x double> %out
}

define arm_aapcs_vfpcc <2 x double> @shuffle2_f64(<2 x double> %src) {
; CHECK-LABEL: shuffle2_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src, <2 x double> undef, <2 x i32> <i32 1, i32 0>
  ret <2 x double> %out
}

define arm_aapcs_vfpcc <2 x double> @shuffle3_f64(<2 x double> %src) {
; CHECK-LABEL: shuffle3_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src, <2 x double> undef, <2 x i32> <i32 undef, i32 1>
  ret <2 x double> %out
}

define arm_aapcs_vfpcc <4 x double> @shuffle4_f64(<2 x double> %src1, <2 x double> %src2) {
; CHECK-LABEL: shuffle4_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s6
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov.f32 s10, s2
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src1, <2 x double> %src2, <4 x i32> <i32 3, i32 1, i32 2, i32 0>
  ret <4 x double> %out
}
define arm_aapcs_vfpcc <4 x double> @shuffle5_f64(<2 x double> %src1, <2 x double> %src2) {
; CHECK-LABEL: shuffle5_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s6
; CHECK-NEXT:    vmov.f32 s10, s4
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s11, s5
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src1, <2 x double> %src2, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x double> %out
}
define arm_aapcs_vfpcc <2 x double> @shuffle6_f64(<2 x double> %src1, <2 x double> %src2) {
; CHECK-LABEL: shuffle6_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vmov.f32 s3, s7
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src1, <2 x double> %src2, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %out
}
define arm_aapcs_vfpcc <2 x double> @shuffle7_f64(<2 x double> %src1, <2 x double> %src2) {
; CHECK-LABEL: shuffle7_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s6
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src1, <2 x double> %src2, <2 x i32> <i32 3, i32 1>
  ret <2 x double> %out
}
define arm_aapcs_vfpcc <2 x double> @shuffle8_f64(<2 x double> %src1, <2 x double> %src2) {
; CHECK-LABEL: shuffle8_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f32 s7, s3
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x double> %src1, <2 x double> %src2, <2 x i32> <i32 2, i32 1>
  ret <2 x double> %out
}
define arm_aapcs_vfpcc <8 x double> @shuffle9_f64(<4 x double> %src1, <4 x double> %src2) {
; CHECK-LV-LABEL: shuffle9_f64:
; CHECK-LV:       @ %bb.0: @ %entry
; CHECK-LV-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-LV-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-LV-NEXT:    vmov q5, q2
; CHECK-LV-NEXT:    vmov.f32 s16, s0
; CHECK-LV-NEXT:    vmov.f32 s18, s20
; CHECK-LV-NEXT:    vmov.f32 s20, s2
; CHECK-LV-NEXT:    vmov.f32 s10, s12
; CHECK-LV-NEXT:    vmov.f32 s19, s21
; CHECK-LV-NEXT:    vmov.f32 s8, s4
; CHECK-LV-NEXT:    vmov.f32 s17, s1
; CHECK-LV-NEXT:    vmov.f32 s21, s3
; CHECK-LV-NEXT:    vmov q0, q4
; CHECK-LV-NEXT:    vmov.f32 s12, s6
; CHECK-LV-NEXT:    vmov.f32 s11, s13
; CHECK-LV-NEXT:    vmov.f32 s9, s5
; CHECK-LV-NEXT:    vmov.f32 s13, s7
; CHECK-LV-NEXT:    vmov q1, q5
; CHECK-LV-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-LV-NEXT:    bx lr
;
; CHECK-LIS-LABEL: shuffle9_f64:
; CHECK-LIS:       @ %bb.0: @ %entry
; CHECK-LIS-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    vmov q5, q2
; CHECK-LIS-NEXT:    vmov q4, q0
; CHECK-LIS-NEXT:    vmov.f32 s2, s20
; CHECK-LIS-NEXT:    vmov.f32 s20, s18
; CHECK-LIS-NEXT:    vmov.f32 s10, s12
; CHECK-LIS-NEXT:    vmov.f32 s3, s21
; CHECK-LIS-NEXT:    vmov.f32 s8, s4
; CHECK-LIS-NEXT:    vmov.f32 s21, s19
; CHECK-LIS-NEXT:    vmov.f32 s12, s6
; CHECK-LIS-NEXT:    vmov.f32 s11, s13
; CHECK-LIS-NEXT:    vmov.f32 s9, s5
; CHECK-LIS-NEXT:    vmov.f32 s13, s7
; CHECK-LIS-NEXT:    vmov q1, q5
; CHECK-LIS-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    bx lr

entry:
  %out = shufflevector <4 x double> %src1, <4 x double> %src2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  ret <8 x double> %out
}




define arm_aapcs_vfpcc <4 x i64> @shuffle4_i64(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: shuffle4_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s6
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov.f32 s10, s2
; CHECK-NEXT:    vmov.f32 s11, s3
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src1, <2 x i64> %src2, <4 x i32> <i32 3, i32 1, i32 2, i32 0>
  ret <4 x i64> %out
}
define arm_aapcs_vfpcc <4 x i64> @shuffle5_i64(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: shuffle5_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s8, s6
; CHECK-NEXT:    vmov.f32 s10, s4
; CHECK-NEXT:    vmov.f32 s4, s2
; CHECK-NEXT:    vmov.f32 s6, s0
; CHECK-NEXT:    vmov.f32 s9, s7
; CHECK-NEXT:    vmov.f32 s11, s5
; CHECK-NEXT:    vmov.f32 s5, s3
; CHECK-NEXT:    vmov.f32 s7, s1
; CHECK-NEXT:    vmov q0, q2
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src1, <2 x i64> %src2, <4 x i32> <i32 3, i32 2, i32 1, i32 0>
  ret <4 x i64> %out
}
define arm_aapcs_vfpcc <2 x i64> @shuffle6_i64(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: shuffle6_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s2, s6
; CHECK-NEXT:    vmov.f32 s3, s7
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src1, <2 x i64> %src2, <2 x i32> <i32 0, i32 3>
  ret <2 x i64> %out
}
define arm_aapcs_vfpcc <2 x i64> @shuffle7_i64(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: shuffle7_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s6
; CHECK-NEXT:    vmov.f32 s1, s7
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src1, <2 x i64> %src2, <2 x i32> <i32 3, i32 1>
  ret <2 x i64> %out
}
define arm_aapcs_vfpcc <2 x i64> @shuffle8_i64(<2 x i64> %src1, <2 x i64> %src2) {
; CHECK-LABEL: shuffle8_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s6, s2
; CHECK-NEXT:    vmov.f32 s7, s3
; CHECK-NEXT:    vmov q0, q1
; CHECK-NEXT:    bx lr
entry:
  %out = shufflevector <2 x i64> %src1, <2 x i64> %src2, <2 x i32> <i32 2, i32 1>
  ret <2 x i64> %out
}
define arm_aapcs_vfpcc <8 x i64> @shuffle9_i64(<4 x i64> %src1, <4 x i64> %src2) {
; CHECK-LV-LABEL: shuffle9_i64:
; CHECK-LV:       @ %bb.0: @ %entry
; CHECK-LV-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-LV-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-LV-NEXT:    vmov q5, q2
; CHECK-LV-NEXT:    vmov.f32 s16, s0
; CHECK-LV-NEXT:    vmov.f32 s18, s20
; CHECK-LV-NEXT:    vmov.f32 s20, s2
; CHECK-LV-NEXT:    vmov.f32 s10, s12
; CHECK-LV-NEXT:    vmov.f32 s19, s21
; CHECK-LV-NEXT:    vmov.f32 s8, s4
; CHECK-LV-NEXT:    vmov.f32 s17, s1
; CHECK-LV-NEXT:    vmov.f32 s21, s3
; CHECK-LV-NEXT:    vmov q0, q4
; CHECK-LV-NEXT:    vmov.f32 s12, s6
; CHECK-LV-NEXT:    vmov.f32 s11, s13
; CHECK-LV-NEXT:    vmov.f32 s9, s5
; CHECK-LV-NEXT:    vmov.f32 s13, s7
; CHECK-LV-NEXT:    vmov q1, q5
; CHECK-LV-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-LV-NEXT:    bx lr
;
; CHECK-LIS-LABEL: shuffle9_i64:
; CHECK-LIS:       @ %bb.0: @ %entry
; CHECK-LIS-NEXT:    .vsave {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    vpush {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    vmov q5, q2
; CHECK-LIS-NEXT:    vmov q4, q0
; CHECK-LIS-NEXT:    vmov.f32 s2, s20
; CHECK-LIS-NEXT:    vmov.f32 s20, s18
; CHECK-LIS-NEXT:    vmov.f32 s10, s12
; CHECK-LIS-NEXT:    vmov.f32 s3, s21
; CHECK-LIS-NEXT:    vmov.f32 s8, s4
; CHECK-LIS-NEXT:    vmov.f32 s21, s19
; CHECK-LIS-NEXT:    vmov.f32 s12, s6
; CHECK-LIS-NEXT:    vmov.f32 s11, s13
; CHECK-LIS-NEXT:    vmov.f32 s9, s5
; CHECK-LIS-NEXT:    vmov.f32 s13, s7
; CHECK-LIS-NEXT:    vmov q1, q5
; CHECK-LIS-NEXT:    vpop {d8, d9, d10, d11}
; CHECK-LIS-NEXT:    bx lr

entry:
  %out = shufflevector <4 x i64> %src1, <4 x i64> %src2, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
  ret <8 x i64> %out
}


define arm_aapcs_vfpcc <4 x i32> @insert_i32(i32 %a) {
; CHECK-LABEL: insert_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.32 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <4 x i32> undef, i32 %a, i32 0
  ret <4 x i32> %res
}

define arm_aapcs_vfpcc <8 x i16> @insert_i16(i16 %a) {
; CHECK-LABEL: insert_i16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.16 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <8 x i16> undef, i16 %a, i32 0
  ret <8 x i16> %res
}

define arm_aapcs_vfpcc <16 x i8> @insert_i8(i8 %a) {
; CHECK-LABEL: insert_i8:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.8 q0[0], r0
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <16 x i8> undef, i8 %a, i32 0
  ret <16 x i8> %res
}

define arm_aapcs_vfpcc <2 x i64> @insert_i64(i64 %a) {
; CHECK-LABEL: insert_i64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.32 q0[0], r0
; CHECK-NEXT:    vmov.32 q0[1], r1
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <2 x i64> undef, i64 %a, i32 0
  ret <2 x i64> %res
}

define arm_aapcs_vfpcc <4 x float> @insert_f32(float %a) {
; CHECK-LABEL: insert_f32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <4 x float> undef, float %a, i32 0
  ret <4 x float> %res
}

define arm_aapcs_vfpcc <8 x half> @insert_f16(half %a) {
; CHECK-LABEL: insert_f16:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <8 x half> undef, half %a, i32 0
  ret <8 x half> %res
}

define arm_aapcs_vfpcc <2 x double> @insert_f64(double %a) {
; CHECK-LABEL: insert_f64:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = insertelement <2 x double> undef, double %a, i32 0
  ret <2 x double> %res
}

define arm_aapcs_vfpcc i64 @scalar_to_vector_i32(<8 x i16> %v) {
; CHECK-LABEL: scalar_to_vector_i32:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    .pad #8
; CHECK-NEXT:    sub sp, #8
; CHECK-NEXT:    adr r2, .LCPI88_0
; CHECK-NEXT:    vmov.u16 r0, q0[0]
; CHECK-NEXT:    vldrw.u32 q0, [r2]
; CHECK-NEXT:    mov r1, sp
; CHECK-NEXT:    vmov.32 q0[0], r0
; CHECK-NEXT:    vstrh.32 q0, [r1]
; CHECK-NEXT:    ldrd r0, r1, [sp], #8
; CHECK-NEXT:    bx lr
; CHECK-NEXT:    .p2align 4
; CHECK-NEXT:  @ %bb.1:
; CHECK-NEXT:  .LCPI88_0:
; CHECK-NEXT:    .zero 4
; CHECK-NEXT:    .long 7 @ 0x7
; CHECK-NEXT:    .long 1 @ 0x1
; CHECK-NEXT:    .long 9 @ 0x9
entry:
  %f = shufflevector <8 x i16> %v, <8 x i16> <i16 undef, i16 7, i16 1, i16 9, i16 undef, i16 undef, i16 undef, i16 undef>, <4 x i32> <i32 0, i32 9, i32 10, i32 11>
  %0 = bitcast <4 x i16> %f to i64
  ret i64 %0
}


define arm_aapcs_vfpcc i32 @extract_i32_0(<4 x i32> %a) {
; CHECK-LABEL: extract_i32_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s0
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <4 x i32> %a, i32 0
  ret i32 %res
}

define arm_aapcs_vfpcc i32 @extract_i32_3(<4 x i32> %a) {
; CHECK-LABEL: extract_i32_3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, s3
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <4 x i32> %a, i32 3
  ret i32 %res
}

define arm_aapcs_vfpcc i16 @extract_i16_0(<8 x i16> %a) {
; CHECK-LABEL: extract_i16_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q0[0]
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <8 x i16> %a, i32 0
  ret i16 %res
}

define arm_aapcs_vfpcc i16 @extract_i16_3(<8 x i16> %a) {
; CHECK-LABEL: extract_i16_3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u16 r0, q0[3]
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <8 x i16> %a, i32 3
  ret i16 %res
}

define arm_aapcs_vfpcc i8 @extract_i8_0(<16 x i8> %a) {
; CHECK-LABEL: extract_i8_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[0]
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <16 x i8> %a, i32 0
  ret i8 %res
}

define arm_aapcs_vfpcc i8 @extract_i8_3(<16 x i8> %a) {
; CHECK-LABEL: extract_i8_3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.u8 r0, q0[3]
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <16 x i8> %a, i32 3
  ret i8 %res
}

define arm_aapcs_vfpcc i64 @extract_i64_0(<2 x i64> %a) {
; CHECK-LABEL: extract_i64_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d0
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <2 x i64> %a, i32 0
  ret i64 %res
}

define arm_aapcs_vfpcc i64 @extract_i64_1(<2 x i64> %a) {
; CHECK-LABEL: extract_i64_1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov r0, r1, d1
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <2 x i64> %a, i32 1
  ret i64 %res
}

define arm_aapcs_vfpcc float @extract_f32_0(<4 x float> %a) {
; CHECK-LABEL: extract_f32_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <4 x float> %a, i32 0
  ret float %res
}

define arm_aapcs_vfpcc float @extract_f32_3(<4 x float> %a) {
; CHECK-LABEL: extract_f32_3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s3
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <4 x float> %a, i32 3
  ret float %res
}

define arm_aapcs_vfpcc half @extract_f16_0(<8 x half> %a) {
; CHECK-LABEL: extract_f16_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <8 x half> %a, i32 0
  ret half %res
}

define arm_aapcs_vfpcc half @extract_f16_3(<8 x half> %a) {
; CHECK-LABEL: extract_f16_3:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmovx.f16 s0, s1
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <8 x half> %a, i32 3
  ret half %res
}

define arm_aapcs_vfpcc double @extract_f64_0(<2 x double> %a) {
; CHECK-LABEL: extract_f64_0:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <2 x double> %a, i32 0
  ret double %res
}

define arm_aapcs_vfpcc double @extract_f64_1(<2 x double> %a) {
; CHECK-LABEL: extract_f64_1:
; CHECK:       @ %bb.0: @ %entry
; CHECK-NEXT:    vmov.f32 s0, s2
; CHECK-NEXT:    vmov.f32 s1, s3
; CHECK-NEXT:    bx lr
entry:
  %res = extractelement <2 x double> %a, i32 1
  ret double %res
}

