/*
Copyright (c) 2018, MIPI Alliance, Inc. 
All rights reserved.

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions
are met:

* Redistributions of source code must retain the above copyright
  notice, this list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright
  notice, this list of conditions and the following disclaimer in
  the documentation and/or other materials provided with the
  distribution.

* Neither the name of the copyright holder nor the names of its
  contributors may be used to endorse or promote products derived
  from this software without specific prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
"AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/*
 * Contributors:
 * Norbert Schulz (Intel Corporation) - Initial API and implementation
 */

#include "mipi_syst_gtest.h"

#if defined(MIPI_SYST_PCFG_ENABLE_PLATFORM_STATE_DATA) &&\
	defined(MIPI_SYST_PCFG_ENABLE_DEFAULT_SCATTER_WRITE) &&\
	defined(MIPI_SYST_PCFG_ENABLE_CATID32_API)

class MipiSysTFixtureCatId32 : public MipiSysTFixtureOutput
{
public:
	void SetUp() {
		MipiSysTFixtureOutput::SetUp();
	}

	void TearDown(){
		MipiSysTFixtureOutput::TearDown();
	}

	const char * mipi_syst_write_catalog32_message(struct mipi_syst_handle* svh,
	struct mipi_syst_msglocation* loc,
		enum mipi_syst_severity severity,
		mipi_syst_u32 catid)
	{
		static std::string result;

		::mipi_syst_write_catalog32_message(svh, loc, severity, catid);
		result = sstr.str();
		sstr.str("");

		return result.c_str();
	}
};

TEST_F(MipiSysTFixtureCatId32, syst_catid32_basic)
{
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_0(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_1(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE,1 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_2(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_3(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_4(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_5(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2,3,4,5 )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_6(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2,3,4,5,6 )
		);

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)

	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_0_LOC16(0,MIPI_SYST_SEVERITY_WARNING, 1, 0xCAFEBABE )
		);
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_0_LOC32(0,MIPI_SYST_SEVERITY_WARNING, 1, 0xCAFEBABE )
		);

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
	EXPECT_STREQ(
		xform(""),
		MIPI_SYST_CATALOG32_0_LOCADDR(0,MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
#endif
#endif
}

TEST_F(MipiSysTFixtureCatId32, syst_catid32_noloc_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATALOG32_0(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG32_1(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG32_2(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG32_3(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG32_4(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG32_5(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG32_6(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5, 6)
		);
}

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)
#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
TEST_F(MipiSysTFixtureCatId32, syst_catid32_locaddr_output)
{
#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATALOG32_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATALOG32_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG32_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG32_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG32_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG32_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG32_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG32_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG32_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG32_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG32_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG32_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG32_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5, 6)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG32_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, 1, 2, 3, 4, 5, 6)
		);
#endif
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS

TEST_F(MipiSysTFixtureCatId32, syst_catid32_loc16_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATALOG32_0_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG32_1_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG32_2_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG32_3_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG32_4_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG32_5_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG32_6_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, 1, 2, 3, 4, 5, 6)
		);
}

TEST_F(MipiSysTFixtureCatId32, syst_catid32_loc32_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATALOG32_0_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATALOG32_1_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATALOG32_2_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATALOG32_3_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATALOG32_4_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATALOG32_5_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATALOG32_6_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, 1, 2, 3, 4, 5, 6)
		);
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD


TEST_F(MipiSysTFixtureCatId32, syst_catprintf32_noloc_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF32_0(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy" )
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_1(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_2(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_3(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_4(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_5(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012233[typ=3:1 mu=1:2 sev=3 len]<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_6(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5, 6)
		);
}

#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD)
#if defined(MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS)
TEST_F(MipiSysTFixtureCatId32, syst_catprintf32_locaddr_output)
{
#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF32_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy")
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF32_0_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy")
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_1_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_2_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_3_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_4_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_5_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5)
		);
#endif

#if defined(MIPI_SYST_PCFG_ENABLE_64BIT_ADDR)
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>03<D64>12345678aabbccdd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5, 6)
		);
#else
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>02<D32>12345678<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_6_LOCADDR(ph, MIPI_SYST_SEVERITY_WARNING, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5, 6)
		);
#endif
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_ADDRESS

TEST_F(MipiSysTFixtureCatId32, syst_catprintf2_loc16_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF32_0_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy")
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_1_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_2_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_3_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_4_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_5_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>00<D32>5678abcd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_6_LOC16(ph, MIPI_SYST_SEVERITY_WARNING, 0xabcd, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5, 6)
		);
}

TEST_F(MipiSysTFixtureCatId32, syst_catprintf32_loc32_output)
{
	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0004<D32>cafebabe<FLAG>"),
		MIPI_SYST_CATPRINTF32_0_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy")
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0008<D32>cafebabe<D32>00000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_1_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>000c<D32>cafebabe<D64>0000000200000001<FLAG>"),
		MIPI_SYST_CATPRINTF32_2_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1, 2)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0010<D32>cafebabe<D64>0000000200000001<D32>00000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_3_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1, 2, 3)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0014<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<FLAG>"),
		MIPI_SYST_CATPRINTF32_4_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1, 2, 3, 4)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>0018<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D32>00000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_5_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5)
		);

	EXPECT_STREQ(
		xform("<D32TS>01012333[typ=3:1 mu=1:2 sev=3 loc len]<D8>01<D64>12345678aabbccdd<D16>001c<D32>cafebabe<D64>0000000200000001<D64>0000000400000003<D64>0000000600000005<FLAG>"),
		MIPI_SYST_CATPRINTF32_6_LOC32(ph, MIPI_SYST_SEVERITY_WARNING, 0xaabbccdd, 0xCAFEBABE, "dummy", 1, 2, 3, 4, 5, 6)
		);
}
#endif //MIPI_SYST_PCFG_ENABLE_LOCATION_RECORD
#endif //MIPI_SYST_PCFG_ENABLE_PLATFORM_STATE_DATA && MIPI_SYST_PCFG_ENABLE_DEFAULT_SCATTER_WRITE && MIPI_SYST_PCFG_ENABLE_CATID32_API